@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property metric Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
 * @property stat Statistic of the metrics to return.
 * @property unit Unit of the metrics to return.
 */
public data class
PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs(
    public val metric: Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs>,
    public val stat: Output<String>,
    public val unit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder()
            .metric(metric.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stat(stat.applyValue({ args0 -> args0 }))
            .unit(unit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs].
 */
@PulumiTagMarker
public class
PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgsBuilder
internal constructor() {
    private var metric:
        Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs>? =
        null

    private var stat: Output<String>? = null

    private var unit: Output<String>? = null

    /**
     * @param value Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("qotyqprmhwwadhmx")
    public suspend fun metric(`value`: Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs>) {
        this.metric = value
    }

    /**
     * @param value Statistic of the metrics to return.
     */
    @JvmName("gowwctkjpwjyodcm")
    public suspend fun stat(`value`: Output<String>) {
        this.stat = value
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("jbxyaiyuydppodmj")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("ticynxsopcnpkrim")
    public suspend fun metric(`value`: PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param argument Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("ipojxvrteylaamot")
    public suspend fun metric(argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgsBuilder.() -> Unit) {
        val toBeMapped =
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.metric = mapped
    }

    /**
     * @param value Statistic of the metrics to return.
     */
    @JvmName("hydlluhfwmltxsme")
    public suspend fun stat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stat = mapped
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("waitxmgyyuwdxvrt")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build(): PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs =
        PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs(
            metric = metric ?: throw PulumiNullFieldException("metric"),
            stat = stat ?: throw PulumiNullFieldException("stat"),
            unit = unit,
        )
}
