@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property predefinedMetricType Metric type.
 * @property resourceLabel Identifies the resource associated with the metric type.
 */
public data class PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs(
    public val predefinedMetricType: Output<String>,
    public val resourceLabel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs.builder()
            .predefinedMetricType(predefinedMetricType.applyValue({ args0 -> args0 }))
            .resourceLabel(resourceLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs].
 */
@PulumiTagMarker
public class PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgsBuilder internal constructor() {
    private var predefinedMetricType: Output<String>? = null

    private var resourceLabel: Output<String>? = null

    /**
     * @param value Metric type.
     */
    @JvmName("qllojughioowswwn")
    public suspend fun predefinedMetricType(`value`: Output<String>) {
        this.predefinedMetricType = value
    }

    /**
     * @param value Identifies the resource associated with the metric type.
     */
    @JvmName("mbwktrdujfpvbulq")
    public suspend fun resourceLabel(`value`: Output<String>) {
        this.resourceLabel = value
    }

    /**
     * @param value Metric type.
     */
    @JvmName("trkoifvyemlweyxi")
    public suspend fun predefinedMetricType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predefinedMetricType = mapped
    }

    /**
     * @param value Identifies the resource associated with the metric type.
     */
    @JvmName("pbwbhqgdqwqjutdy")
    public suspend fun resourceLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLabel = mapped
    }

    internal fun build(): PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs =
        PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs(
            predefinedMetricType = predefinedMetricType ?: throw
                PulumiNullFieldException("predefinedMetricType"),
            resourceLabel = resourceLabel,
        )
}
