@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maxHealthyPercentage Specifies the upper limit on the number of instances that are in the InService or Pending state with a healthy status during an instance replacement activity.
 * @property minHealthyPercentage Specifies the lower limit on the number of instances that must be in the InService state with a healthy status during an instance replacement activity.
 */
public data class GetGroupInstanceMaintenancePolicy(
    public val maxHealthyPercentage: Int,
    public val minHealthyPercentage: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GetGroupInstanceMaintenancePolicy): GetGroupInstanceMaintenancePolicy = GetGroupInstanceMaintenancePolicy(
            maxHealthyPercentage = javaType.maxHealthyPercentage(),
            minHealthyPercentage = javaType.minHealthyPercentage(),
        )
    }
}
