@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property onDemandAllocationStrategy Strategy used when launching on-demand instances.
 * @property onDemandBaseCapacity Absolute minimum amount of desired capacity that must be fulfilled by on-demand instances.
 * @property onDemandPercentageAboveBaseCapacity
 * @property spotAllocationStrategy Strategy used when launching Spot instances.
 * @property spotInstancePools Number of Spot pools per availability zone to allocate capacity.
 * @property spotMaxPrice Maximum price per unit hour that the user is willing to pay for the Spot instances.
 */
public data class GetGroupMixedInstancesPolicyInstancesDistribution(
    public val onDemandAllocationStrategy: String,
    public val onDemandBaseCapacity: Int,
    public val onDemandPercentageAboveBaseCapacity: Int,
    public val spotAllocationStrategy: String,
    public val spotInstancePools: Int,
    public val spotMaxPrice: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GetGroupMixedInstancesPolicyInstancesDistribution): GetGroupMixedInstancesPolicyInstancesDistribution =
            GetGroupMixedInstancesPolicyInstancesDistribution(
                onDemandAllocationStrategy = javaType.onDemandAllocationStrategy(),
                onDemandBaseCapacity = javaType.onDemandBaseCapacity(),
                onDemandPercentageAboveBaseCapacity = javaType.onDemandPercentageAboveBaseCapacity(),
                spotAllocationStrategy = javaType.spotAllocationStrategy(),
                spotInstancePools = javaType.spotInstancePools(),
                spotMaxPrice = javaType.spotMaxPrice(),
            )
    }
}
