@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property launchTemplateSpecifications List of overriding launch template specification objects.
 * @property overrides List of properties overriding the same properties in the launch template.
 */
public data class GetGroupMixedInstancesPolicyLaunchTemplate(
    public val launchTemplateSpecifications: List<GetGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification>,
    public val overrides: List<GetGroupMixedInstancesPolicyLaunchTemplateOverride>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GetGroupMixedInstancesPolicyLaunchTemplate): GetGroupMixedInstancesPolicyLaunchTemplate = GetGroupMixedInstancesPolicyLaunchTemplate(
            launchTemplateSpecifications = javaType.launchTemplateSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.GetGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.Companion.toKotlin(args0)
                })
            }),
            overrides = javaType.overrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.GetGroupMixedInstancesPolicyLaunchTemplateOverride.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
