@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property instanceRequirements List of instance requirements objects.
 * * `accelerator_count - List of objects describing the minimum and maximum number of accelerators for an instance type.
 * @property instanceType Overriding instance type.
 * @property launchTemplateSpecifications List of overriding launch template specification objects.
 * @property weightedCapacity Number of capacity units, which gives the instance type a proportional weight to other instance types.
 */
public data class GetGroupMixedInstancesPolicyLaunchTemplateOverride(
    public val instanceRequirements: List<GetGroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirement>,
    public val instanceType: String,
    public val launchTemplateSpecifications: List<GetGroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification>,
    public val weightedCapacity: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GetGroupMixedInstancesPolicyLaunchTemplateOverride): GetGroupMixedInstancesPolicyLaunchTemplateOverride =
            GetGroupMixedInstancesPolicyLaunchTemplateOverride(
                instanceRequirements = javaType.instanceRequirements().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.GetGroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirement.Companion.toKotlin(args0)
                    })
                }),
                instanceType = javaType.instanceType(),
                launchTemplateSpecifications = javaType.launchTemplateSpecifications().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.GetGroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification.Companion.toKotlin(args0)
                    })
                }),
                weightedCapacity = javaType.weightedCapacity(),
            )
    }
}
