@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property instanceReusePolicies List of instance reuse policy objects.
 * @property maxGroupPreparedCapacity
 * @property minSize Minimum number of instances to maintain in the warm pool.
 * @property poolState Instance state to transition to after the lifecycle actions are complete.
 */
public data class GetGroupWarmPool(
    public val instanceReusePolicies: List<GetGroupWarmPoolInstanceReusePolicy>,
    public val maxGroupPreparedCapacity: Int,
    public val minSize: Int,
    public val poolState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GetGroupWarmPool): GetGroupWarmPool = GetGroupWarmPool(
            instanceReusePolicies = javaType.instanceReusePolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.GetGroupWarmPoolInstanceReusePolicy.Companion.toKotlin(args0)
                })
            }),
            maxGroupPreparedCapacity = javaType.maxGroupPreparedCapacity(),
            minSize = javaType.minSize(),
            poolState = javaType.poolState(),
        )
    }
}
