@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultResult
 * @property heartbeatTimeout
 * @property lifecycleTransition
 * @property name Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
 * @property notificationMetadata
 * @property notificationTargetArn
 * @property roleArn
 */
public data class GroupInitialLifecycleHook(
    public val defaultResult: String? = null,
    public val heartbeatTimeout: Int? = null,
    public val lifecycleTransition: String,
    public val name: String,
    public val notificationMetadata: String? = null,
    public val notificationTargetArn: String? = null,
    public val roleArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupInitialLifecycleHook): GroupInitialLifecycleHook = GroupInitialLifecycleHook(
            defaultResult = javaType.defaultResult().map({ args0 -> args0 }).orElse(null),
            heartbeatTimeout = javaType.heartbeatTimeout().map({ args0 -> args0 }).orElse(null),
            lifecycleTransition = javaType.lifecycleTransition(),
            name = javaType.name(),
            notificationMetadata = javaType.notificationMetadata().map({ args0 -> args0 }).orElse(null),
            notificationTargetArn = javaType.notificationTargetArn().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
