@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property instancesDistribution Nested argument containing settings on how to mix on-demand and Spot instances in the Auto Scaling group. Defined below.
 * @property launchTemplate Nested argument containing launch template settings along with the overrides to specify multiple instance types and weights. Defined below.
 */
public data class GroupMixedInstancesPolicy(
    public val instancesDistribution: GroupMixedInstancesPolicyInstancesDistribution? = null,
    public val launchTemplate: GroupMixedInstancesPolicyLaunchTemplate,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupMixedInstancesPolicy): GroupMixedInstancesPolicy = GroupMixedInstancesPolicy(
            instancesDistribution = javaType.instancesDistribution().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.GroupMixedInstancesPolicyInstancesDistribution.Companion.toKotlin(args0)
                })
            }).orElse(null),
            launchTemplate = javaType.launchTemplate().let({ args0 ->
                com.pulumi.aws.autoscaling.kotlin.outputs.GroupMixedInstancesPolicyLaunchTemplate.Companion.toKotlin(args0)
            }),
        )
    }
}
