@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property onDemandAllocationStrategy Strategy to use when launching on-demand instances. Valid values: `prioritized`, `lowest-price`. Default: `prioritized`.
 * @property onDemandBaseCapacity Absolute minimum amount of desired capacity that must be fulfilled by on-demand instances. Default: `0`.
 * @property onDemandPercentageAboveBaseCapacity Percentage split between on-demand and Spot instances above the base on-demand capacity. Default: `100`.
 * @property spotAllocationStrategy How to allocate capacity across the Spot pools. Valid values: `lowest-price`, `capacity-optimized`, `capacity-optimized-prioritized`, and `price-capacity-optimized`. Default: `lowest-price`.
 * @property spotInstancePools Number of Spot pools per availability zone to allocate capacity. EC2 Auto Scaling selects the cheapest Spot pools and evenly allocates Spot capacity across the number of Spot pools that you specify. Only available with `spot_allocation_strategy` set to `lowest-price`. Otherwise it must be set to `0`, if it has been defined before. Default: `2`.
 * @property spotMaxPrice Maximum price per unit hour that the user is willing to pay for the Spot instances. Default: an empty string which means the on-demand price.
 */
public data class GroupMixedInstancesPolicyInstancesDistribution(
    public val onDemandAllocationStrategy: String? = null,
    public val onDemandBaseCapacity: Int? = null,
    public val onDemandPercentageAboveBaseCapacity: Int? = null,
    public val spotAllocationStrategy: String? = null,
    public val spotInstancePools: Int? = null,
    public val spotMaxPrice: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupMixedInstancesPolicyInstancesDistribution): GroupMixedInstancesPolicyInstancesDistribution =
            GroupMixedInstancesPolicyInstancesDistribution(
                onDemandAllocationStrategy = javaType.onDemandAllocationStrategy().map({ args0 ->
                    args0
                }).orElse(null),
                onDemandBaseCapacity = javaType.onDemandBaseCapacity().map({ args0 -> args0 }).orElse(null),
                onDemandPercentageAboveBaseCapacity = javaType.onDemandPercentageAboveBaseCapacity().map({ args0 ->
                    args0
                }).orElse(null),
                spotAllocationStrategy = javaType.spotAllocationStrategy().map({ args0 -> args0 }).orElse(null),
                spotInstancePools = javaType.spotInstancePools().map({ args0 -> args0 }).orElse(null),
                spotMaxPrice = javaType.spotMaxPrice().map({ args0 -> args0 }).orElse(null),
            )
    }
}
