@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property launchTemplateSpecification Override the instance launch template specification in the Launch Template.
 * @property overrides List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
 */
public data class GroupMixedInstancesPolicyLaunchTemplate(
    public val launchTemplateSpecification: GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification,
    public val overrides: List<GroupMixedInstancesPolicyLaunchTemplateOverride>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupMixedInstancesPolicyLaunchTemplate): GroupMixedInstancesPolicyLaunchTemplate = GroupMixedInstancesPolicyLaunchTemplate(
            launchTemplateSpecification = javaType.launchTemplateSpecification().let({ args0 ->
                com.pulumi.aws.autoscaling.kotlin.outputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.Companion.toKotlin(args0)
            }),
            overrides = javaType.overrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.GroupMixedInstancesPolicyLaunchTemplateOverride.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
