@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key Key
 * @property propagateAtLaunch Enables propagation of the tag to
 * Amazon EC2 instances launched via this ASG
 * To declare multiple tags, additional `tag` blocks can be specified.
 * > **NOTE:** Other AWS APIs may automatically add special tags to their associated Auto Scaling Group for management purposes, such as ECS Capacity Providers adding the `AmazonECSManaged` tag. These generally should be included in the configuration so the provider does not attempt to remove them and so if the `min_size` was greater than zero on creation, that these tag(s) are applied to any initial EC2 Instances in the Auto Scaling Group. If these tag(s) were missing in the Auto Scaling Group configuration on creation, affected EC2 Instances missing the tags may require manual intervention of adding the tags to ensure they work properly with the other AWS service.
 * @property value Value
 */
public data class GroupTag(
    public val key: String,
    public val propagateAtLaunch: Boolean,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupTag): GroupTag = GroupTag(
            key = javaType.key(),
            propagateAtLaunch = javaType.propagateAtLaunch(),
            `value` = javaType.`value`(),
        )
    }
}
