@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property identifier Identifies the traffic source. For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
 * @property type Provides additional context for the value of Identifier.
 * The following lists the valid values:
 * `elb` if `identifier` is the name of a Classic Load Balancer.
 * `elbv2` if `identifier` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
 * `vpc-lattice` if `identifier` is the ARN of a VPC Lattice target group.
 */
public data class GroupTrafficSource(
    public val identifier: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupTrafficSource): GroupTrafficSource = GroupTrafficSource(
            identifier = javaType.identifier(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
