@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property reuseOnScaleIn Whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
 */
public data class GroupWarmPoolInstanceReusePolicy(
    public val reuseOnScaleIn: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupWarmPoolInstanceReusePolicy): GroupWarmPoolInstanceReusePolicy = GroupWarmPoolInstanceReusePolicy(
            reuseOnScaleIn = javaType.reuseOnScaleIn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
