@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maxCapacityBreachBehavior Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Valid values are `HonorMaxCapacity` or `IncreaseMaxCapacity`. Default is `HonorMaxCapacity`.
 * @property maxCapacityBuffer Size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. Valid range is `0` to `100`. If set to `0`, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
 * @property metricSpecification This structure includes the metrics and target utilization to use for predictive scaling.
 * @property mode Predictive scaling mode. Valid values are `ForecastAndScale` and `ForecastOnly`. Default is `ForecastOnly`.
 * @property schedulingBufferTime Amount of time, in seconds, by which the instance launch time can be advanced. Minimum is `0`.
 */
public data class PolicyPredictiveScalingConfiguration(
    public val maxCapacityBreachBehavior: String? = null,
    public val maxCapacityBuffer: String? = null,
    public val metricSpecification: PolicyPredictiveScalingConfigurationMetricSpecification,
    public val mode: String? = null,
    public val schedulingBufferTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.PolicyPredictiveScalingConfiguration): PolicyPredictiveScalingConfiguration = PolicyPredictiveScalingConfiguration(
            maxCapacityBreachBehavior = javaType.maxCapacityBreachBehavior().map({ args0 ->
                args0
            }).orElse(null),
            maxCapacityBuffer = javaType.maxCapacityBuffer().map({ args0 -> args0 }).orElse(null),
            metricSpecification = javaType.metricSpecification().let({ args0 ->
                com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfigurationMetricSpecification.Companion.toKotlin(args0)
            }),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            schedulingBufferTime = javaType.schedulingBufferTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
