@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property customizedCapacityMetricSpecification Customized capacity metric specification. The field is only valid when you use `customized_load_metric_specification`
 * @property customizedLoadMetricSpecification Customized load metric specification.
 * @property customizedScalingMetricSpecification Customized scaling metric specification.
 * @property predefinedLoadMetricSpecification Predefined load metric specification.
 * @property predefinedMetricPairSpecification Metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
 * @property predefinedScalingMetricSpecification Predefined scaling metric specification.
 * @property targetValue Target value for the metric.
 */
public data class PolicyPredictiveScalingConfigurationMetricSpecification(
    public val customizedCapacityMetricSpecification: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecification? =
        null,
    public val customizedLoadMetricSpecification: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecification? =
        null,
    public val customizedScalingMetricSpecification: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecification? =
        null,
    public val predefinedLoadMetricSpecification: PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification? =
        null,
    public val predefinedMetricPairSpecification: PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification? =
        null,
    public val predefinedScalingMetricSpecification: PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecification? =
        null,
    public val targetValue: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.PolicyPredictiveScalingConfigurationMetricSpecification): PolicyPredictiveScalingConfigurationMetricSpecification =
            PolicyPredictiveScalingConfigurationMetricSpecification(
                customizedCapacityMetricSpecification = javaType.customizedCapacityMetricSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                customizedLoadMetricSpecification = javaType.customizedLoadMetricSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                customizedScalingMetricSpecification = javaType.customizedScalingMetricSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                predefinedLoadMetricSpecification = javaType.predefinedLoadMetricSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                predefinedMetricPairSpecification = javaType.predefinedMetricPairSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                predefinedScalingMetricSpecification = javaType.predefinedScalingMetricSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                targetValue = javaType.targetValue(),
            )
    }
}
