@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property predefinedMetricType Metric type. Valid values are `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`, or `ALBTargetGroupRequestCount`.
 * @property resourceLabel Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification(
    public val predefinedMetricType: String,
    public val resourceLabel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification): PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification =
            PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification(
                predefinedMetricType = javaType.predefinedMetricType(),
                resourceLabel = javaType.resourceLabel().map({ args0 -> args0 }).orElse(null),
            )
    }
}
