@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property predefinedMetricType Which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization`, the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric. Valid values are `ASGCPUUtilization`, `ASGNetworkIn`, `ASGNetworkOut`, or `ALBRequestCount`.
 * @property resourceLabel Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification(
    public val predefinedMetricType: String,
    public val resourceLabel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification): PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification =
            PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification(
                predefinedMetricType = javaType.predefinedMetricType(),
                resourceLabel = javaType.resourceLabel().map({ args0 -> args0 }).orElse(null),
            )
    }
}
