@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property customizedMetricSpecification Customized metric. Conflicts with `predefined_metric_specification`.
 * @property disableScaleIn Whether scale in by the target tracking policy is disabled.
 * @property predefinedMetricSpecification Predefined metric. Conflicts with `customized_metric_specification`.
 * @property targetValue Target value for the metric.
 */
public data class PolicyTargetTrackingConfiguration(
    public val customizedMetricSpecification: PolicyTargetTrackingConfigurationCustomizedMetricSpecification? = null,
    public val disableScaleIn: Boolean? = null,
    public val predefinedMetricSpecification: PolicyTargetTrackingConfigurationPredefinedMetricSpecification? = null,
    public val targetValue: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.PolicyTargetTrackingConfiguration): PolicyTargetTrackingConfiguration = PolicyTargetTrackingConfiguration(
            customizedMetricSpecification = javaType.customizedMetricSpecification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecification.Companion.toKotlin(args0)
                })
            }).orElse(null),
            disableScaleIn = javaType.disableScaleIn().map({ args0 -> args0 }).orElse(null),
            predefinedMetricSpecification = javaType.predefinedMetricSpecification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.PolicyTargetTrackingConfigurationPredefinedMetricSpecification.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetValue = javaType.targetValue(),
        )
    }
}
