@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin

import com.pulumi.aws.autoscalingplans.ScalingPlanArgs.builder
import com.pulumi.aws.autoscalingplans.kotlin.inputs.ScalingPlanApplicationSourceArgs
import com.pulumi.aws.autoscalingplans.kotlin.inputs.ScalingPlanApplicationSourceArgsBuilder
import com.pulumi.aws.autoscalingplans.kotlin.inputs.ScalingPlanScalingInstructionArgs
import com.pulumi.aws.autoscalingplans.kotlin.inputs.ScalingPlanScalingInstructionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages an AWS Auto Scaling scaling plan.
 * More information can be found in the [AWS Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-aws-auto-scaling.html).
 * > **NOTE:** The AWS Auto Scaling service uses an AWS IAM service-linked role to manage predictive scaling of Amazon EC2 Auto Scaling groups. The service attempts to automatically create this role the first time a scaling plan with predictive scaling enabled is created.
 * An `aws.iam.ServiceLinkedRole` resource can be used to manually manage this role.
 * See the [AWS documentation](https://docs.aws.amazon.com/autoscaling/plans/userguide/aws-auto-scaling-service-linked-roles.html#create-service-linked-role-manual) for more details.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import Auto Scaling scaling plans using the `name`. For example:
 * ```sh
 * $ pulumi import aws:autoscalingplans/scalingPlan:ScalingPlan example MyScale1
 * ```
 * @property applicationSource CloudFormation stack or set of tags. You can create one scaling plan per application source.
 * @property name Name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
 * @property scalingInstructions Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
 */
public data class ScalingPlanArgs(
    public val applicationSource: Output<ScalingPlanApplicationSourceArgs>? = null,
    public val name: Output<String>? = null,
    public val scalingInstructions: Output<List<ScalingPlanScalingInstructionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscalingplans.ScalingPlanArgs> {
    override fun toJava(): com.pulumi.aws.autoscalingplans.ScalingPlanArgs =
        com.pulumi.aws.autoscalingplans.ScalingPlanArgs.builder()
            .applicationSource(applicationSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .scalingInstructions(
                scalingInstructions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScalingPlanArgs].
 */
@PulumiTagMarker
public class ScalingPlanArgsBuilder internal constructor() {
    private var applicationSource: Output<ScalingPlanApplicationSourceArgs>? = null

    private var name: Output<String>? = null

    private var scalingInstructions: Output<List<ScalingPlanScalingInstructionArgs>>? = null

    /**
     * @param value CloudFormation stack or set of tags. You can create one scaling plan per application source.
     */
    @JvmName("hdxjsbxnohbhnmev")
    public suspend fun applicationSource(`value`: Output<ScalingPlanApplicationSourceArgs>) {
        this.applicationSource = value
    }

    /**
     * @param value Name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
     */
    @JvmName("ybawcdrbdvpeyjlc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     */
    @JvmName("fcktyvxnxeofqlkp")
    public suspend fun scalingInstructions(`value`: Output<List<ScalingPlanScalingInstructionArgs>>) {
        this.scalingInstructions = value
    }

    @JvmName("hlnwrcivutppwqfp")
    public suspend fun scalingInstructions(vararg values: Output<ScalingPlanScalingInstructionArgs>) {
        this.scalingInstructions = Output.all(values.asList())
    }

    /**
     * @param values Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     */
    @JvmName("fscjsytfwwtdmsyw")
    public suspend fun scalingInstructions(values: List<Output<ScalingPlanScalingInstructionArgs>>) {
        this.scalingInstructions = Output.all(values)
    }

    /**
     * @param value CloudFormation stack or set of tags. You can create one scaling plan per application source.
     */
    @JvmName("wkqbstjqmajvypxf")
    public suspend fun applicationSource(`value`: ScalingPlanApplicationSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSource = mapped
    }

    /**
     * @param argument CloudFormation stack or set of tags. You can create one scaling plan per application source.
     */
    @JvmName("wfmiiltkmkrbledq")
    public suspend fun applicationSource(argument: suspend ScalingPlanApplicationSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ScalingPlanApplicationSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationSource = mapped
    }

    /**
     * @param value Name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
     */
    @JvmName("qlwnoueeuaurlmhr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     */
    @JvmName("osqcujxpjtoueeat")
    public suspend fun scalingInstructions(`value`: List<ScalingPlanScalingInstructionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingInstructions = mapped
    }

    /**
     * @param argument Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     */
    @JvmName("qulxgmhcuxunqwpe")
    public suspend fun scalingInstructions(argument: List<suspend ScalingPlanScalingInstructionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingPlanScalingInstructionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scalingInstructions = mapped
    }

    /**
     * @param argument Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     */
    @JvmName("spwoouqmlrjxjyah")
    public suspend fun scalingInstructions(vararg argument: suspend ScalingPlanScalingInstructionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingPlanScalingInstructionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scalingInstructions = mapped
    }

    /**
     * @param argument Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     */
    @JvmName("xybqduqekkqkmshf")
    public suspend fun scalingInstructions(argument: suspend ScalingPlanScalingInstructionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingPlanScalingInstructionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.scalingInstructions = mapped
    }

    /**
     * @param values Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     */
    @JvmName("pxpdaylrlosvldli")
    public suspend fun scalingInstructions(vararg values: ScalingPlanScalingInstructionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingInstructions = mapped
    }

    internal fun build(): ScalingPlanArgs = ScalingPlanArgs(
        applicationSource = applicationSource,
        name = name,
        scalingInstructions = scalingInstructions,
    )
}
