@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.inputs

import com.pulumi.aws.autoscalingplans.inputs.ScalingPlanApplicationSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cloudformationStackArn ARN of a AWS CloudFormation stack.
 * @property tagFilters Set of tags.
 */
public data class ScalingPlanApplicationSourceArgs(
    public val cloudformationStackArn: Output<String>? = null,
    public val tagFilters: Output<List<ScalingPlanApplicationSourceTagFilterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscalingplans.inputs.ScalingPlanApplicationSourceArgs> {
    override fun toJava(): com.pulumi.aws.autoscalingplans.inputs.ScalingPlanApplicationSourceArgs =
        com.pulumi.aws.autoscalingplans.inputs.ScalingPlanApplicationSourceArgs.builder()
            .cloudformationStackArn(cloudformationStackArn?.applyValue({ args0 -> args0 }))
            .tagFilters(
                tagFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScalingPlanApplicationSourceArgs].
 */
@PulumiTagMarker
public class ScalingPlanApplicationSourceArgsBuilder internal constructor() {
    private var cloudformationStackArn: Output<String>? = null

    private var tagFilters: Output<List<ScalingPlanApplicationSourceTagFilterArgs>>? = null

    /**
     * @param value ARN of a AWS CloudFormation stack.
     */
    @JvmName("qbosarjfchoaprvy")
    public suspend fun cloudformationStackArn(`value`: Output<String>) {
        this.cloudformationStackArn = value
    }

    /**
     * @param value Set of tags.
     */
    @JvmName("lhihjjepegljmqhj")
    public suspend fun tagFilters(`value`: Output<List<ScalingPlanApplicationSourceTagFilterArgs>>) {
        this.tagFilters = value
    }

    @JvmName("vvtdefymqlijbimt")
    public suspend fun tagFilters(vararg values: Output<ScalingPlanApplicationSourceTagFilterArgs>) {
        this.tagFilters = Output.all(values.asList())
    }

    /**
     * @param values Set of tags.
     */
    @JvmName("sktpujxnxtnhaiph")
    public suspend fun tagFilters(values: List<Output<ScalingPlanApplicationSourceTagFilterArgs>>) {
        this.tagFilters = Output.all(values)
    }

    /**
     * @param value ARN of a AWS CloudFormation stack.
     */
    @JvmName("quagfjjreoisdruq")
    public suspend fun cloudformationStackArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudformationStackArn = mapped
    }

    /**
     * @param value Set of tags.
     */
    @JvmName("eufkrlxdryyxxpor")
    public suspend fun tagFilters(`value`: List<ScalingPlanApplicationSourceTagFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagFilters = mapped
    }

    /**
     * @param argument Set of tags.
     */
    @JvmName("eikexwdixcrcbbuy")
    public suspend fun tagFilters(argument: List<suspend ScalingPlanApplicationSourceTagFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingPlanApplicationSourceTagFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tagFilters = mapped
    }

    /**
     * @param argument Set of tags.
     */
    @JvmName("wijfwfyyihktmdno")
    public suspend fun tagFilters(vararg argument: suspend ScalingPlanApplicationSourceTagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingPlanApplicationSourceTagFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tagFilters = mapped
    }

    /**
     * @param argument Set of tags.
     */
    @JvmName("fcotnoyvqfkaptbb")
    public suspend fun tagFilters(argument: suspend ScalingPlanApplicationSourceTagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingPlanApplicationSourceTagFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tagFilters = mapped
    }

    /**
     * @param values Set of tags.
     */
    @JvmName("dtfmppyncanwhrla")
    public suspend fun tagFilters(vararg values: ScalingPlanApplicationSourceTagFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagFilters = mapped
    }

    internal fun build(): ScalingPlanApplicationSourceArgs = ScalingPlanApplicationSourceArgs(
        cloudformationStackArn = cloudformationStackArn,
        tagFilters = tagFilters,
    )
}
