@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.inputs

import com.pulumi.aws.autoscalingplans.inputs.ScalingPlanApplicationSourceTagFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key Tag key.
 * @property values Tag values.
 */
public data class ScalingPlanApplicationSourceTagFilterArgs(
    public val key: Output<String>,
    public val values: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscalingplans.inputs.ScalingPlanApplicationSourceTagFilterArgs> {
    override fun toJava(): com.pulumi.aws.autoscalingplans.inputs.ScalingPlanApplicationSourceTagFilterArgs =
        com.pulumi.aws.autoscalingplans.inputs.ScalingPlanApplicationSourceTagFilterArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ScalingPlanApplicationSourceTagFilterArgs].
 */
@PulumiTagMarker
public class ScalingPlanApplicationSourceTagFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Tag key.
     */
    @JvmName("tmbclmwisodafwsu")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Tag values.
     */
    @JvmName("fdggxjkxpvuotffh")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("yenylhgluttaxwll")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Tag values.
     */
    @JvmName("xsuqwyatbqhvjnhe")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Tag key.
     */
    @JvmName("yfxmennakopffryn")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Tag values.
     */
    @JvmName("agniarslllafvjmn")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Tag values.
     */
    @JvmName("owidqedrloqwdhwu")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ScalingPlanApplicationSourceTagFilterArgs =
        ScalingPlanApplicationSourceTagFilterArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            values = values,
        )
}
