@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property predefinedLoadMetricType Metric type. Valid values: `ALBTargetGroupRequestCount`, `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`.
 * @property resourceLabel Identifies the resource associated with the metric type.
 */
public data class ScalingPlanScalingInstructionPredefinedLoadMetricSpecification(
    public val predefinedLoadMetricType: String,
    public val resourceLabel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscalingplans.outputs.ScalingPlanScalingInstructionPredefinedLoadMetricSpecification): ScalingPlanScalingInstructionPredefinedLoadMetricSpecification =
            ScalingPlanScalingInstructionPredefinedLoadMetricSpecification(
                predefinedLoadMetricType = javaType.predefinedLoadMetricType(),
                resourceLabel = javaType.resourceLabel().map({ args0 -> args0 }).orElse(null),
            )
    }
}
