@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property customizedScalingMetricSpecification Customized metric. You can specify either `customized_scaling_metric_specification` or `predefined_scaling_metric_specification`.
 * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedScalingMetricSpecification.html).
 * @property disableScaleIn Boolean indicating whether scale in by the target tracking scaling policy is disabled. Defaults to `false`.
 * @property estimatedInstanceWarmup Estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
 * This value is used only if the resource is an Auto Scaling group.
 * @property predefinedScalingMetricSpecification Predefined metric. You can specify either `predefined_scaling_metric_specification` or `customized_scaling_metric_specification`.
 * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html).
 * @property scaleInCooldown Amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
 * This value is not used if the scalable resource is an Auto Scaling group.
 * @property scaleOutCooldown Amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
 * This value is not used if the scalable resource is an Auto Scaling group.
 * @property targetValue Target value for the metric.
 */
public data class ScalingPlanScalingInstructionTargetTrackingConfiguration(
    public val customizedScalingMetricSpecification: ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification? =
        null,
    public val disableScaleIn: Boolean? = null,
    public val estimatedInstanceWarmup: Int? = null,
    public val predefinedScalingMetricSpecification: ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification? =
        null,
    public val scaleInCooldown: Int? = null,
    public val scaleOutCooldown: Int? = null,
    public val targetValue: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscalingplans.outputs.ScalingPlanScalingInstructionTargetTrackingConfiguration): ScalingPlanScalingInstructionTargetTrackingConfiguration =
            ScalingPlanScalingInstructionTargetTrackingConfiguration(
                customizedScalingMetricSpecification = javaType.customizedScalingMetricSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscalingplans.kotlin.outputs.ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                disableScaleIn = javaType.disableScaleIn().map({ args0 -> args0 }).orElse(null),
                estimatedInstanceWarmup = javaType.estimatedInstanceWarmup().map({ args0 -> args0 }).orElse(null),
                predefinedScalingMetricSpecification = javaType.predefinedScalingMetricSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscalingplans.kotlin.outputs.ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                scaleInCooldown = javaType.scaleInCooldown().map({ args0 -> args0 }).orElse(null),
                scaleOutCooldown = javaType.scaleOutCooldown().map({ args0 -> args0 }).orElse(null),
                targetValue = javaType.targetValue(),
            )
    }
}
