@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.BackupFunctions.getFrameworkPlain
import com.pulumi.aws.backup.BackupFunctions.getPlanPlain
import com.pulumi.aws.backup.BackupFunctions.getReportPlanPlain
import com.pulumi.aws.backup.BackupFunctions.getSelectionPlain
import com.pulumi.aws.backup.BackupFunctions.getVaultPlain
import com.pulumi.aws.backup.kotlin.inputs.GetFrameworkPlainArgs
import com.pulumi.aws.backup.kotlin.inputs.GetFrameworkPlainArgsBuilder
import com.pulumi.aws.backup.kotlin.inputs.GetPlanPlainArgs
import com.pulumi.aws.backup.kotlin.inputs.GetPlanPlainArgsBuilder
import com.pulumi.aws.backup.kotlin.inputs.GetReportPlanPlainArgs
import com.pulumi.aws.backup.kotlin.inputs.GetReportPlanPlainArgsBuilder
import com.pulumi.aws.backup.kotlin.inputs.GetSelectionPlainArgs
import com.pulumi.aws.backup.kotlin.inputs.GetSelectionPlainArgsBuilder
import com.pulumi.aws.backup.kotlin.inputs.GetVaultPlainArgs
import com.pulumi.aws.backup.kotlin.inputs.GetVaultPlainArgsBuilder
import com.pulumi.aws.backup.kotlin.outputs.GetFrameworkResult
import com.pulumi.aws.backup.kotlin.outputs.GetPlanResult
import com.pulumi.aws.backup.kotlin.outputs.GetReportPlanResult
import com.pulumi.aws.backup.kotlin.outputs.GetSelectionResult
import com.pulumi.aws.backup.kotlin.outputs.GetVaultResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.backup.kotlin.outputs.GetFrameworkResult.Companion.toKotlin as getFrameworkResultToKotlin
import com.pulumi.aws.backup.kotlin.outputs.GetPlanResult.Companion.toKotlin as getPlanResultToKotlin
import com.pulumi.aws.backup.kotlin.outputs.GetReportPlanResult.Companion.toKotlin as getReportPlanResultToKotlin
import com.pulumi.aws.backup.kotlin.outputs.GetSelectionResult.Companion.toKotlin as getSelectionResultToKotlin
import com.pulumi.aws.backup.kotlin.outputs.GetVaultResult.Companion.toKotlin as getVaultResultToKotlin

public object BackupFunctions {
    /**
     * Use this data source to get information on an existing backup framework.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.backup.getFramework({
     *     name: "my_example_backup_framework_name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.backup.get_framework(name="my_example_backup_framework_name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Backup.GetFramework.Invoke(new()
     *     {
     *         Name = "my_example_backup_framework_name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := backup.LookupFramework(ctx, &backup.LookupFrameworkArgs{
     * 			Name: "my_example_backup_framework_name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.backup.BackupFunctions;
     * import com.pulumi.aws.backup.inputs.GetFrameworkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = BackupFunctions.getFramework(GetFrameworkArgs.builder()
     *             .name("my_example_backup_framework_name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:backup:getFramework
     *       Arguments:
     *         name: my_example_backup_framework_name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFramework.
     * @return A collection of values returned by getFramework.
     */
    public suspend fun getFramework(argument: GetFrameworkPlainArgs): GetFrameworkResult =
        getFrameworkResultToKotlin(getFrameworkPlain(argument.toJava()).await())

    /**
     * @see [getFramework].
     * @param name Backup framework name.
     * @param tags Tag key-value pair applied to those AWS resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided.
     * @return A collection of values returned by getFramework.
     */
    public suspend fun getFramework(name: String, tags: Map<String, String>? = null): GetFrameworkResult {
        val argument = GetFrameworkPlainArgs(
            name = name,
            tags = tags,
        )
        return getFrameworkResultToKotlin(getFrameworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getFramework].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;backup&#46;kotlin&#46;inputs&#46;GetFrameworkPlainArgs].
     * @return A collection of values returned by getFramework.
     */
    public suspend fun getFramework(argument: suspend GetFrameworkPlainArgsBuilder.() -> Unit): GetFrameworkResult {
        val builder = GetFrameworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFrameworkResultToKotlin(getFrameworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information on an existing backup plan.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.backup.getPlan({
     *     planId: "my_example_backup_plan_id",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.backup.get_plan(plan_id="my_example_backup_plan_id")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Backup.GetPlan.Invoke(new()
     *     {
     *         PlanId = "my_example_backup_plan_id",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := backup.LookupPlan(ctx, &backup.LookupPlanArgs{
     * 			PlanId: "my_example_backup_plan_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.backup.BackupFunctions;
     * import com.pulumi.aws.backup.inputs.GetPlanArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = BackupFunctions.getPlan(GetPlanArgs.builder()
     *             .planId("my_example_backup_plan_id")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:backup:getPlan
     *       Arguments:
     *         planId: my_example_backup_plan_id
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPlan.
     * @return A collection of values returned by getPlan.
     */
    public suspend fun getPlan(argument: GetPlanPlainArgs): GetPlanResult =
        getPlanResultToKotlin(getPlanPlain(argument.toJava()).await())

    /**
     * @see [getPlan].
     * @param planId Backup plan ID.
     * @param tags Metadata that you can assign to help organize the plans you create.
     * @return A collection of values returned by getPlan.
     */
    public suspend fun getPlan(planId: String, tags: Map<String, String>? = null): GetPlanResult {
        val argument = GetPlanPlainArgs(
            planId = planId,
            tags = tags,
        )
        return getPlanResultToKotlin(getPlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getPlan].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;backup&#46;kotlin&#46;inputs&#46;GetPlanPlainArgs].
     * @return A collection of values returned by getPlan.
     */
    public suspend fun getPlan(argument: suspend GetPlanPlainArgsBuilder.() -> Unit): GetPlanResult {
        val builder = GetPlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPlanResultToKotlin(getPlanPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information on an existing backup report plan.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.backup.getReportPlan({
     *     name: "my_example_backup_report_plan_name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.backup.get_report_plan(name="my_example_backup_report_plan_name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Backup.GetReportPlan.Invoke(new()
     *     {
     *         Name = "my_example_backup_report_plan_name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := backup.LookupReportPlan(ctx, &backup.LookupReportPlanArgs{
     * 			Name: "my_example_backup_report_plan_name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.backup.BackupFunctions;
     * import com.pulumi.aws.backup.inputs.GetReportPlanArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = BackupFunctions.getReportPlan(GetReportPlanArgs.builder()
     *             .name("my_example_backup_report_plan_name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:backup:getReportPlan
     *       Arguments:
     *         name: my_example_backup_report_plan_name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getReportPlan.
     * @return A collection of values returned by getReportPlan.
     */
    public suspend fun getReportPlan(argument: GetReportPlanPlainArgs): GetReportPlanResult =
        getReportPlanResultToKotlin(getReportPlanPlain(argument.toJava()).await())

    /**
     * @see [getReportPlan].
     * @param name Backup report plan name.
     * @param tags Metadata that you can assign to help organize the report plans you create.
     * @return A collection of values returned by getReportPlan.
     */
    public suspend fun getReportPlan(name: String, tags: Map<String, String>? = null): GetReportPlanResult {
        val argument = GetReportPlanPlainArgs(
            name = name,
            tags = tags,
        )
        return getReportPlanResultToKotlin(getReportPlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getReportPlan].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;backup&#46;kotlin&#46;inputs&#46;GetReportPlanPlainArgs].
     * @return A collection of values returned by getReportPlan.
     */
    public suspend fun getReportPlan(argument: suspend GetReportPlanPlainArgsBuilder.() -> Unit): GetReportPlanResult {
        val builder = GetReportPlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReportPlanResultToKotlin(getReportPlanPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information on an existing backup selection.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.backup.getSelection({
     *     planId: exampleAwsBackupPlan.id,
     *     selectionId: "selection-id-example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.backup.get_selection(plan_id=example_aws_backup_plan["id"],
     *     selection_id="selection-id-example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Backup.GetSelection.Invoke(new()
     *     {
     *         PlanId = exampleAwsBackupPlan.Id,
     *         SelectionId = "selection-id-example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := backup.LookupSelection(ctx, &backup.LookupSelectionArgs{
     * 			PlanId:      exampleAwsBackupPlan.Id,
     * 			SelectionId: "selection-id-example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.backup.BackupFunctions;
     * import com.pulumi.aws.backup.inputs.GetSelectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = BackupFunctions.getSelection(GetSelectionArgs.builder()
     *             .planId(exampleAwsBackupPlan.id())
     *             .selectionId("selection-id-example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:backup:getSelection
     *       Arguments:
     *         planId: ${exampleAwsBackupPlan.id}
     *         selectionId: selection-id-example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSelection.
     * @return A collection of values returned by getSelection.
     */
    public suspend fun getSelection(argument: GetSelectionPlainArgs): GetSelectionResult =
        getSelectionResultToKotlin(getSelectionPlain(argument.toJava()).await())

    /**
     * @see [getSelection].
     * @param planId Backup plan ID associated with the selection of resources.
     * @param selectionId Backup selection ID.
     * @return A collection of values returned by getSelection.
     */
    public suspend fun getSelection(planId: String, selectionId: String): GetSelectionResult {
        val argument = GetSelectionPlainArgs(
            planId = planId,
            selectionId = selectionId,
        )
        return getSelectionResultToKotlin(getSelectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSelection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;backup&#46;kotlin&#46;inputs&#46;GetSelectionPlainArgs].
     * @return A collection of values returned by getSelection.
     */
    public suspend fun getSelection(argument: suspend GetSelectionPlainArgsBuilder.() -> Unit): GetSelectionResult {
        val builder = GetSelectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSelectionResultToKotlin(getSelectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information on an existing backup vault.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.backup.getVault({
     *     name: "example_backup_vault",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.backup.get_vault(name="example_backup_vault")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Backup.GetVault.Invoke(new()
     *     {
     *         Name = "example_backup_vault",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := backup.LookupVault(ctx, &backup.LookupVaultArgs{
     * 			Name: "example_backup_vault",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.backup.BackupFunctions;
     * import com.pulumi.aws.backup.inputs.GetVaultArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = BackupFunctions.getVault(GetVaultArgs.builder()
     *             .name("example_backup_vault")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:backup:getVault
     *       Arguments:
     *         name: example_backup_vault
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVault.
     * @return A collection of values returned by getVault.
     */
    public suspend fun getVault(argument: GetVaultPlainArgs): GetVaultResult =
        getVaultResultToKotlin(getVaultPlain(argument.toJava()).await())

    /**
     * @see [getVault].
     * @param name Name of the backup vault.
     * @param tags Metadata that you can assign to help organize the resources that you create.
     * @return A collection of values returned by getVault.
     */
    public suspend fun getVault(name: String, tags: Map<String, String>? = null): GetVaultResult {
        val argument = GetVaultPlainArgs(
            name = name,
            tags = tags,
        )
        return getVaultResultToKotlin(getVaultPlain(argument.toJava()).await())
    }

    /**
     * @see [getVault].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;backup&#46;kotlin&#46;inputs&#46;GetVaultPlainArgs].
     * @return A collection of values returned by getVault.
     */
    public suspend fun getVault(argument: suspend GetVaultPlainArgsBuilder.() -> Unit): GetVaultResult {
        val builder = GetVaultPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVaultResultToKotlin(getVaultPlain(builtArgument.toJava()).await())
    }
}
