@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.FrameworkArgs.builder
import com.pulumi.aws.backup.kotlin.inputs.FrameworkControlArgs
import com.pulumi.aws.backup.kotlin.inputs.FrameworkControlArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup Framework resource.
 * > **Note:** For the Deployment Status of the Framework to be successful, please turn on resource tracking to enable AWS Config recording to track configuration changes of your backup resources. This can be done from the AWS Console.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.backup.Framework("Example", {
 *     name: "exampleFramework",
 *     description: "this is an example framework",
 *     controls: [
 *         {
 *             name: "BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK",
 *             inputParameters: [{
 *                 name: "requiredRetentionDays",
 *                 value: "35",
 *             }],
 *         },
 *         {
 *             name: "BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK",
 *             inputParameters: [
 *                 {
 *                     name: "requiredFrequencyUnit",
 *                     value: "hours",
 *                 },
 *                 {
 *                     name: "requiredRetentionDays",
 *                     value: "35",
 *                 },
 *                 {
 *                     name: "requiredFrequencyValue",
 *                     value: "1",
 *                 },
 *             ],
 *         },
 *         {
 *             name: "BACKUP_RECOVERY_POINT_ENCRYPTED",
 *         },
 *         {
 *             name: "BACKUP_RESOURCES_PROTECTED_BY_BACKUP_PLAN",
 *             scope: {
 *                 complianceResourceTypes: ["EBS"],
 *             },
 *         },
 *         {
 *             name: "BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED",
 *         },
 *         {
 *             name: "BACKUP_RESOURCES_PROTECTED_BY_BACKUP_VAULT_LOCK",
 *             inputParameters: [
 *                 {
 *                     name: "maxRetentionDays",
 *                     value: "100",
 *                 },
 *                 {
 *                     name: "minRetentionDays",
 *                     value: "1",
 *                 },
 *             ],
 *             scope: {
 *                 complianceResourceTypes: ["EBS"],
 *             },
 *         },
 *         {
 *             name: "BACKUP_LAST_RECOVERY_POINT_CREATED",
 *             inputParameters: [
 *                 {
 *                     name: "recoveryPointAgeUnit",
 *                     value: "days",
 *                 },
 *                 {
 *                     name: "recoveryPointAgeValue",
 *                     value: "1",
 *                 },
 *             ],
 *             scope: {
 *                 complianceResourceTypes: ["EBS"],
 *             },
 *         },
 *     ],
 *     tags: {
 *         Name: "Example Framework",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.backup.Framework("Example",
 *     name="exampleFramework",
 *     description="this is an example framework",
 *     controls=[
 *         {
 *             "name": "BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK",
 *             "input_parameters": [{
 *                 "name": "requiredRetentionDays",
 *                 "value": "35",
 *             }],
 *         },
 *         {
 *             "name": "BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK",
 *             "input_parameters": [
 *                 {
 *                     "name": "requiredFrequencyUnit",
 *                     "value": "hours",
 *                 },
 *                 {
 *                     "name": "requiredRetentionDays",
 *                     "value": "35",
 *                 },
 *                 {
 *                     "name": "requiredFrequencyValue",
 *                     "value": "1",
 *                 },
 *             ],
 *         },
 *         {
 *             "name": "BACKUP_RECOVERY_POINT_ENCRYPTED",
 *         },
 *         {
 *             "name": "BACKUP_RESOURCES_PROTECTED_BY_BACKUP_PLAN",
 *             "scope": {
 *                 "compliance_resource_types": ["EBS"],
 *             },
 *         },
 *         {
 *             "name": "BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED",
 *         },
 *         {
 *             "name": "BACKUP_RESOURCES_PROTECTED_BY_BACKUP_VAULT_LOCK",
 *             "input_parameters": [
 *                 {
 *                     "name": "maxRetentionDays",
 *                     "value": "100",
 *                 },
 *                 {
 *                     "name": "minRetentionDays",
 *                     "value": "1",
 *                 },
 *             ],
 *             "scope": {
 *                 "compliance_resource_types": ["EBS"],
 *             },
 *         },
 *         {
 *             "name": "BACKUP_LAST_RECOVERY_POINT_CREATED",
 *             "input_parameters": [
 *                 {
 *                     "name": "recoveryPointAgeUnit",
 *                     "value": "days",
 *                 },
 *                 {
 *                     "name": "recoveryPointAgeValue",
 *                     "value": "1",
 *                 },
 *             ],
 *             "scope": {
 *                 "compliance_resource_types": ["EBS"],
 *             },
 *         },
 *     ],
 *     tags={
 *         "Name": "Example Framework",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Backup.Framework("Example", new()
 *     {
 *         Name = "exampleFramework",
 *         Description = "this is an example framework",
 *         Controls = new[]
 *         {
 *             new Aws.Backup.Inputs.FrameworkControlArgs
 *             {
 *                 Name = "BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK",
 *                 InputParameters = new[]
 *                 {
 *                     new Aws.Backup.Inputs.FrameworkControlInputParameterArgs
 *                     {
 *                         Name = "requiredRetentionDays",
 *                         Value = "35",
 *                     },
 *                 },
 *             },
 *             new Aws.Backup.Inputs.FrameworkControlArgs
 *             {
 *                 Name = "BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK",
 *                 InputParameters = new[]
 *                 {
 *                     new Aws.Backup.Inputs.FrameworkControlInputParameterArgs
 *                     {
 *                         Name = "requiredFrequencyUnit",
 *                         Value = "hours",
 *                     },
 *                     new Aws.Backup.Inputs.FrameworkControlInputParameterArgs
 *                     {
 *                         Name = "requiredRetentionDays",
 *                         Value = "35",
 *                     },
 *                     new Aws.Backup.Inputs.FrameworkControlInputParameterArgs
 *                     {
 *                         Name = "requiredFrequencyValue",
 *                         Value = "1",
 *                     },
 *                 },
 *             },
 *             new Aws.Backup.Inputs.FrameworkControlArgs
 *             {
 *                 Name = "BACKUP_RECOVERY_POINT_ENCRYPTED",
 *             },
 *             new Aws.Backup.Inputs.FrameworkControlArgs
 *             {
 *                 Name = "BACKUP_RESOURCES_PROTECTED_BY_BACKUP_PLAN",
 *                 Scope = new Aws.Backup.Inputs.FrameworkControlScopeArgs
 *                 {
 *                     ComplianceResourceTypes = new[]
 *                     {
 *                         "EBS",
 *                     },
 *                 },
 *             },
 *             new Aws.Backup.Inputs.FrameworkControlArgs
 *             {
 *                 Name = "BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED",
 *             },
 *             new Aws.Backup.Inputs.FrameworkControlArgs
 *             {
 *                 Name = "BACKUP_RESOURCES_PROTECTED_BY_BACKUP_VAULT_LOCK",
 *                 InputParameters = new[]
 *                 {
 *                     new Aws.Backup.Inputs.FrameworkControlInputParameterArgs
 *                     {
 *                         Name = "maxRetentionDays",
 *                         Value = "100",
 *                     },
 *                     new Aws.Backup.Inputs.FrameworkControlInputParameterArgs
 *                     {
 *                         Name = "minRetentionDays",
 *                         Value = "1",
 *                     },
 *                 },
 *                 Scope = new Aws.Backup.Inputs.FrameworkControlScopeArgs
 *                 {
 *                     ComplianceResourceTypes = new[]
 *                     {
 *                         "EBS",
 *                     },
 *                 },
 *             },
 *             new Aws.Backup.Inputs.FrameworkControlArgs
 *             {
 *                 Name = "BACKUP_LAST_RECOVERY_POINT_CREATED",
 *                 InputParameters = new[]
 *                 {
 *                     new Aws.Backup.Inputs.FrameworkControlInputParameterArgs
 *                     {
 *                         Name = "recoveryPointAgeUnit",
 *                         Value = "days",
 *                     },
 *                     new Aws.Backup.Inputs.FrameworkControlInputParameterArgs
 *                     {
 *                         Name = "recoveryPointAgeValue",
 *                         Value = "1",
 *                     },
 *                 },
 *                 Scope = new Aws.Backup.Inputs.FrameworkControlScopeArgs
 *                 {
 *                     ComplianceResourceTypes = new[]
 *                     {
 *                         "EBS",
 *                     },
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Framework" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewFramework(ctx, "Example", &backup.FrameworkArgs{
 * 			Name:        pulumi.String("exampleFramework"),
 * 			Description: pulumi.String("this is an example framework"),
 * 			Controls: backup.FrameworkControlArray{
 * 				&backup.FrameworkControlArgs{
 * 					Name: pulumi.String("BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK"),
 * 					InputParameters: backup.FrameworkControlInputParameterArray{
 * 						&backup.FrameworkControlInputParameterArgs{
 * 							Name:  pulumi.String("requiredRetentionDays"),
 * 							Value: pulumi.String("35"),
 * 						},
 * 					},
 * 				},
 * 				&backup.FrameworkControlArgs{
 * 					Name: pulumi.String("BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK"),
 * 					InputParameters: backup.FrameworkControlInputParameterArray{
 * 						&backup.FrameworkControlInputParameterArgs{
 * 							Name:  pulumi.String("requiredFrequencyUnit"),
 * 							Value: pulumi.String("hours"),
 * 						},
 * 						&backup.FrameworkControlInputParameterArgs{
 * 							Name:  pulumi.String("requiredRetentionDays"),
 * 							Value: pulumi.String("35"),
 * 						},
 * 						&backup.FrameworkControlInputParameterArgs{
 * 							Name:  pulumi.String("requiredFrequencyValue"),
 * 							Value: pulumi.String("1"),
 * 						},
 * 					},
 * 				},
 * 				&backup.FrameworkControlArgs{
 * 					Name: pulumi.String("BACKUP_RECOVERY_POINT_ENCRYPTED"),
 * 				},
 * 				&backup.FrameworkControlArgs{
 * 					Name: pulumi.String("BACKUP_RESOURCES_PROTECTED_BY_BACKUP_PLAN"),
 * 					Scope: &backup.FrameworkControlScopeArgs{
 * 						ComplianceResourceTypes: pulumi.StringArray{
 * 							pulumi.String("EBS"),
 * 						},
 * 					},
 * 				},
 * 				&backup.FrameworkControlArgs{
 * 					Name: pulumi.String("BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED"),
 * 				},
 * 				&backup.FrameworkControlArgs{
 * 					Name: pulumi.String("BACKUP_RESOURCES_PROTECTED_BY_BACKUP_VAULT_LOCK"),
 * 					InputParameters: backup.FrameworkControlInputParameterArray{
 * 						&backup.FrameworkControlInputParameterArgs{
 * 							Name:  pulumi.String("maxRetentionDays"),
 * 							Value: pulumi.String("100"),
 * 						},
 * 						&backup.FrameworkControlInputParameterArgs{
 * 							Name:  pulumi.String("minRetentionDays"),
 * 							Value: pulumi.String("1"),
 * 						},
 * 					},
 * 					Scope: &backup.FrameworkControlScopeArgs{
 * 						ComplianceResourceTypes: pulumi.StringArray{
 * 							pulumi.String("EBS"),
 * 						},
 * 					},
 * 				},
 * 				&backup.FrameworkControlArgs{
 * 					Name: pulumi.String("BACKUP_LAST_RECOVERY_POINT_CREATED"),
 * 					InputParameters: backup.FrameworkControlInputParameterArray{
 * 						&backup.FrameworkControlInputParameterArgs{
 * 							Name:  pulumi.String("recoveryPointAgeUnit"),
 * 							Value: pulumi.String("days"),
 * 						},
 * 						&backup.FrameworkControlInputParameterArgs{
 * 							Name:  pulumi.String("recoveryPointAgeValue"),
 * 							Value: pulumi.String("1"),
 * 						},
 * 					},
 * 					Scope: &backup.FrameworkControlScopeArgs{
 * 						ComplianceResourceTypes: pulumi.StringArray{
 * 							pulumi.String("EBS"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Framework"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Framework;
 * import com.pulumi.aws.backup.FrameworkArgs;
 * import com.pulumi.aws.backup.inputs.FrameworkControlArgs;
 * import com.pulumi.aws.backup.inputs.FrameworkControlScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Framework("example", FrameworkArgs.builder()
 *             .name("exampleFramework")
 *             .description("this is an example framework")
 *             .controls(
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK")
 *                     .inputParameters(FrameworkControlInputParameterArgs.builder()
 *                         .name("requiredRetentionDays")
 *                         .value("35")
 *                         .build())
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK")
 *                     .inputParameters(
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("requiredFrequencyUnit")
 *                             .value("hours")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("requiredRetentionDays")
 *                             .value("35")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("requiredFrequencyValue")
 *                             .value("1")
 *                             .build())
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RECOVERY_POINT_ENCRYPTED")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RESOURCES_PROTECTED_BY_BACKUP_PLAN")
 *                     .scope(FrameworkControlScopeArgs.builder()
 *                         .complianceResourceTypes("EBS")
 *                         .build())
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RESOURCES_PROTECTED_BY_BACKUP_VAULT_LOCK")
 *                     .inputParameters(
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("maxRetentionDays")
 *                             .value("100")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("minRetentionDays")
 *                             .value("1")
 *                             .build())
 *                     .scope(FrameworkControlScopeArgs.builder()
 *                         .complianceResourceTypes("EBS")
 *                         .build())
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_LAST_RECOVERY_POINT_CREATED")
 *                     .inputParameters(
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("recoveryPointAgeUnit")
 *                             .value("days")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("recoveryPointAgeValue")
 *                             .value("1")
 *                             .build())
 *                     .scope(FrameworkControlScopeArgs.builder()
 *                         .complianceResourceTypes("EBS")
 *                         .build())
 *                     .build())
 *             .tags(Map.of("Name", "Example Framework"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:backup:Framework
 *     name: Example
 *     properties:
 *       name: exampleFramework
 *       description: this is an example framework
 *       controls:
 *         - name: BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK
 *           inputParameters:
 *             - name: requiredRetentionDays
 *               value: '35'
 *         - name: BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK
 *           inputParameters:
 *             - name: requiredFrequencyUnit
 *               value: hours
 *             - name: requiredRetentionDays
 *               value: '35'
 *             - name: requiredFrequencyValue
 *               value: '1'
 *         - name: BACKUP_RECOVERY_POINT_ENCRYPTED
 *         - name: BACKUP_RESOURCES_PROTECTED_BY_BACKUP_PLAN
 *           scope:
 *             complianceResourceTypes:
 *               - EBS
 *         - name: BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED
 *         - name: BACKUP_RESOURCES_PROTECTED_BY_BACKUP_VAULT_LOCK
 *           inputParameters:
 *             - name: maxRetentionDays
 *               value: '100'
 *             - name: minRetentionDays
 *               value: '1'
 *           scope:
 *             complianceResourceTypes:
 *               - EBS
 *         - name: BACKUP_LAST_RECOVERY_POINT_CREATED
 *           inputParameters:
 *             - name: recoveryPointAgeUnit
 *               value: days
 *             - name: recoveryPointAgeValue
 *               value: '1'
 *           scope:
 *             complianceResourceTypes:
 *               - EBS
 *       tags:
 *         Name: Example Framework
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup Framework using the `id` which corresponds to the name of the Backup Framework. For example:
 * ```sh
 * $ pulumi import aws:backup/framework:Framework test <id>
 * ```
 * @property controls One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
 * @property description The description of the framework with a maximum of 1,024 characters
 * @property name The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
 * @property tags Metadata that you can assign to help organize the frameworks you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FrameworkArgs(
    public val controls: Output<List<FrameworkControlArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.FrameworkArgs> {
    override fun toJava(): com.pulumi.aws.backup.FrameworkArgs =
        com.pulumi.aws.backup.FrameworkArgs.builder()
            .controls(
                controls?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FrameworkArgs].
 */
@PulumiTagMarker
public class FrameworkArgsBuilder internal constructor() {
    private var controls: Output<List<FrameworkControlArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("tvuuwesbxjdiiwnr")
    public suspend fun controls(`value`: Output<List<FrameworkControlArgs>>) {
        this.controls = value
    }

    @JvmName("pesocsfumywrpjgj")
    public suspend fun controls(vararg values: Output<FrameworkControlArgs>) {
        this.controls = Output.all(values.asList())
    }

    /**
     * @param values One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("kvtausmlplhnjkti")
    public suspend fun controls(values: List<Output<FrameworkControlArgs>>) {
        this.controls = Output.all(values)
    }

    /**
     * @param value The description of the framework with a maximum of 1,024 characters
     */
    @JvmName("wsqmcdijbshgkcqt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    @JvmName("rworjadmaieaxqss")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Metadata that you can assign to help organize the frameworks you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tubcqyoslxfaelim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("irmnttyhivaltrse")
    public suspend fun controls(`value`: List<FrameworkControlArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controls = mapped
    }

    /**
     * @param argument One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("fmcliulqobeboxho")
    public suspend fun controls(argument: List<suspend FrameworkControlArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrameworkControlArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controls = mapped
    }

    /**
     * @param argument One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("aivikijpiqokjapa")
    public suspend fun controls(vararg argument: suspend FrameworkControlArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FrameworkControlArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controls = mapped
    }

    /**
     * @param argument One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("tkcyaahijsddnmos")
    public suspend fun controls(argument: suspend FrameworkControlArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FrameworkControlArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.controls = mapped
    }

    /**
     * @param values One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("ebcwdgspwghgmmtn")
    public suspend fun controls(vararg values: FrameworkControlArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controls = mapped
    }

    /**
     * @param value The description of the framework with a maximum of 1,024 characters
     */
    @JvmName("vlajwhreojcmoveh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    @JvmName("ybuyieeairakdmgv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the frameworks you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uuyaqxlelpqfldcw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the frameworks you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("atjwusmesmoqnmvl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FrameworkArgs = FrameworkArgs(
        controls = controls,
        description = description,
        name = name,
        tags = tags,
    )
}
