@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GlobalSettings].
 */
@PulumiTagMarker
public class GlobalSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalSettingsArgs = GlobalSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalSettingsArgsBuilder.() -> Unit) {
        val builder = GlobalSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GlobalSettings {
        val builtJavaResource = com.pulumi.aws.backup.GlobalSettings(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GlobalSettings(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup Global Settings resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.backup.GlobalSettings("test", {globalSettings: {
 *     isCrossAccountBackupEnabled: "true",
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.backup.GlobalSettings("test", global_settings={
 *     "isCrossAccountBackupEnabled": "true",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Backup.GlobalSettings("test", new()
 *     {
 *         GlobalSettingsList =
 *         {
 *             { "isCrossAccountBackupEnabled", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewGlobalSettings(ctx, "test", &backup.GlobalSettingsArgs{
 * 			GlobalSettings: pulumi.StringMap{
 * 				"isCrossAccountBackupEnabled": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.GlobalSettings;
 * import com.pulumi.aws.backup.GlobalSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GlobalSettings("test", GlobalSettingsArgs.builder()
 *             .globalSettings(Map.of("isCrossAccountBackupEnabled", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:backup:GlobalSettings
 *     properties:
 *       globalSettings:
 *         isCrossAccountBackupEnabled: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup Global Settings using the `id`. For example:
 * ```sh
 * $ pulumi import aws:backup/globalSettings:GlobalSettings example 123456789012
 * ```
 */
public class GlobalSettings internal constructor(
    override val javaResource: com.pulumi.aws.backup.GlobalSettings,
) : KotlinCustomResource(javaResource, GlobalSettingsMapper) {
    /**
     * A list of resources along with the opt-in preferences for the account.
     */
    public val globalSettings: Output<Map<String, String>>
        get() = javaResource.globalSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object GlobalSettingsMapper : ResourceMapper<GlobalSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.GlobalSettings::class == javaResource::class

    override fun map(javaResource: Resource): GlobalSettings = GlobalSettings(
        javaResource as
            com.pulumi.aws.backup.GlobalSettings,
    )
}

/**
 * @see [GlobalSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalSettings].
 */
public suspend fun globalSettings(
    name: String,
    block: suspend GlobalSettingsResourceBuilder.() -> Unit,
): GlobalSettings {
    val builder = GlobalSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalSettings(name: String): GlobalSettings {
    val builder = GlobalSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
