@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.kotlin.outputs.PlanAdvancedBackupSetting
import com.pulumi.aws.backup.kotlin.outputs.PlanRule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.backup.kotlin.outputs.PlanAdvancedBackupSetting.Companion.toKotlin as planAdvancedBackupSettingToKotlin
import com.pulumi.aws.backup.kotlin.outputs.PlanRule.Companion.toKotlin as planRuleToKotlin

/**
 * Builder for [Plan].
 */
@PulumiTagMarker
public class PlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PlanArgs = PlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PlanArgsBuilder.() -> Unit) {
        val builder = PlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Plan {
        val builtJavaResource = com.pulumi.aws.backup.Plan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Plan(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup plan resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.backup.Plan("example", {
 *     name: "my_example_backup_plan",
 *     rules: [{
 *         ruleName: "my_example_backup_rule",
 *         targetVaultName: test.name,
 *         schedule: "cron(0 12 * * ? *)",
 *         lifecycle: {
 *             deleteAfter: 14,
 *         },
 *     }],
 *     advancedBackupSettings: [{
 *         backupOptions: {
 *             WindowsVSS: "enabled",
 *         },
 *         resourceType: "EC2",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.backup.Plan("example",
 *     name="my_example_backup_plan",
 *     rules=[{
 *         "rule_name": "my_example_backup_rule",
 *         "target_vault_name": test["name"],
 *         "schedule": "cron(0 12 * * ? *)",
 *         "lifecycle": {
 *             "delete_after": 14,
 *         },
 *     }],
 *     advanced_backup_settings=[{
 *         "backup_options": {
 *             "windows_vss": "enabled",
 *         },
 *         "resource_type": "EC2",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Backup.Plan("example", new()
 *     {
 *         Name = "my_example_backup_plan",
 *         Rules = new[]
 *         {
 *             new Aws.Backup.Inputs.PlanRuleArgs
 *             {
 *                 RuleName = "my_example_backup_rule",
 *                 TargetVaultName = test.Name,
 *                 Schedule = "cron(0 12 * * ? *)",
 *                 Lifecycle = new Aws.Backup.Inputs.PlanRuleLifecycleArgs
 *                 {
 *                     DeleteAfter = 14,
 *                 },
 *             },
 *         },
 *         AdvancedBackupSettings = new[]
 *         {
 *             new Aws.Backup.Inputs.PlanAdvancedBackupSettingArgs
 *             {
 *                 BackupOptions =
 *                 {
 *                     { "WindowsVSS", "enabled" },
 *                 },
 *                 ResourceType = "EC2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewPlan(ctx, "example", &backup.PlanArgs{
 * 			Name: pulumi.String("my_example_backup_plan"),
 * 			Rules: backup.PlanRuleArray{
 * 				&backup.PlanRuleArgs{
 * 					RuleName:        pulumi.String("my_example_backup_rule"),
 * 					TargetVaultName: pulumi.Any(test.Name),
 * 					Schedule:        pulumi.String("cron(0 12 * * ? *)"),
 * 					Lifecycle: &backup.PlanRuleLifecycleArgs{
 * 						DeleteAfter: pulumi.Int(14),
 * 					},
 * 				},
 * 			},
 * 			AdvancedBackupSettings: backup.PlanAdvancedBackupSettingArray{
 * 				&backup.PlanAdvancedBackupSettingArgs{
 * 					BackupOptions: pulumi.StringMap{
 * 						"WindowsVSS": pulumi.String("enabled"),
 * 					},
 * 					ResourceType: pulumi.String("EC2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Plan;
 * import com.pulumi.aws.backup.PlanArgs;
 * import com.pulumi.aws.backup.inputs.PlanRuleArgs;
 * import com.pulumi.aws.backup.inputs.PlanRuleLifecycleArgs;
 * import com.pulumi.aws.backup.inputs.PlanAdvancedBackupSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Plan("example", PlanArgs.builder()
 *             .name("my_example_backup_plan")
 *             .rules(PlanRuleArgs.builder()
 *                 .ruleName("my_example_backup_rule")
 *                 .targetVaultName(test.name())
 *                 .schedule("cron(0 12 * * ? *)")
 *                 .lifecycle(PlanRuleLifecycleArgs.builder()
 *                     .deleteAfter(14)
 *                     .build())
 *                 .build())
 *             .advancedBackupSettings(PlanAdvancedBackupSettingArgs.builder()
 *                 .backupOptions(Map.of("WindowsVSS", "enabled"))
 *                 .resourceType("EC2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:backup:Plan
 *     properties:
 *       name: my_example_backup_plan
 *       rules:
 *         - ruleName: my_example_backup_rule
 *           targetVaultName: ${test.name}
 *           schedule: cron(0 12 * * ? *)
 *           lifecycle:
 *             deleteAfter: 14
 *       advancedBackupSettings:
 *         - backupOptions:
 *             WindowsVSS: enabled
 *           resourceType: EC2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup Plan using the `id`. For example:
 * ```sh
 * $ pulumi import aws:backup/plan:Plan test <id>
 * ```
 */
public class Plan internal constructor(
    override val javaResource: com.pulumi.aws.backup.Plan,
) : KotlinCustomResource(javaResource, PlanMapper) {
    /**
     * An object that specifies backup options for each resource type.
     */
    public val advancedBackupSettings: Output<List<PlanAdvancedBackupSetting>>?
        get() = javaResource.advancedBackupSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        planAdvancedBackupSettingToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The ARN of the backup plan.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The display name of a backup plan.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    public val rules: Output<List<PlanRule>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    planRuleToKotlin(args0)
                })
            })
        })

    /**
     * Metadata that you can assign to help organize the plans you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Unique, randomly generated, Unicode, UTF-8 encoded string that serves as the version ID of the backup plan.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object PlanMapper : ResourceMapper<Plan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.Plan::class == javaResource::class

    override fun map(javaResource: Resource): Plan = Plan(javaResource as com.pulumi.aws.backup.Plan)
}

/**
 * @see [Plan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Plan].
 */
public suspend fun plan(name: String, block: suspend PlanResourceBuilder.() -> Unit): Plan {
    val builder = PlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Plan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun plan(name: String): Plan {
    val builder = PlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
