@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.PlanArgs.builder
import com.pulumi.aws.backup.kotlin.inputs.PlanAdvancedBackupSettingArgs
import com.pulumi.aws.backup.kotlin.inputs.PlanAdvancedBackupSettingArgsBuilder
import com.pulumi.aws.backup.kotlin.inputs.PlanRuleArgs
import com.pulumi.aws.backup.kotlin.inputs.PlanRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup plan resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.backup.Plan("example", {
 *     name: "my_example_backup_plan",
 *     rules: [{
 *         ruleName: "my_example_backup_rule",
 *         targetVaultName: test.name,
 *         schedule: "cron(0 12 * * ? *)",
 *         lifecycle: {
 *             deleteAfter: 14,
 *         },
 *     }],
 *     advancedBackupSettings: [{
 *         backupOptions: {
 *             WindowsVSS: "enabled",
 *         },
 *         resourceType: "EC2",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.backup.Plan("example",
 *     name="my_example_backup_plan",
 *     rules=[{
 *         "rule_name": "my_example_backup_rule",
 *         "target_vault_name": test["name"],
 *         "schedule": "cron(0 12 * * ? *)",
 *         "lifecycle": {
 *             "delete_after": 14,
 *         },
 *     }],
 *     advanced_backup_settings=[{
 *         "backup_options": {
 *             "windows_vss": "enabled",
 *         },
 *         "resource_type": "EC2",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Backup.Plan("example", new()
 *     {
 *         Name = "my_example_backup_plan",
 *         Rules = new[]
 *         {
 *             new Aws.Backup.Inputs.PlanRuleArgs
 *             {
 *                 RuleName = "my_example_backup_rule",
 *                 TargetVaultName = test.Name,
 *                 Schedule = "cron(0 12 * * ? *)",
 *                 Lifecycle = new Aws.Backup.Inputs.PlanRuleLifecycleArgs
 *                 {
 *                     DeleteAfter = 14,
 *                 },
 *             },
 *         },
 *         AdvancedBackupSettings = new[]
 *         {
 *             new Aws.Backup.Inputs.PlanAdvancedBackupSettingArgs
 *             {
 *                 BackupOptions =
 *                 {
 *                     { "WindowsVSS", "enabled" },
 *                 },
 *                 ResourceType = "EC2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewPlan(ctx, "example", &backup.PlanArgs{
 * 			Name: pulumi.String("my_example_backup_plan"),
 * 			Rules: backup.PlanRuleArray{
 * 				&backup.PlanRuleArgs{
 * 					RuleName:        pulumi.String("my_example_backup_rule"),
 * 					TargetVaultName: pulumi.Any(test.Name),
 * 					Schedule:        pulumi.String("cron(0 12 * * ? *)"),
 * 					Lifecycle: &backup.PlanRuleLifecycleArgs{
 * 						DeleteAfter: pulumi.Int(14),
 * 					},
 * 				},
 * 			},
 * 			AdvancedBackupSettings: backup.PlanAdvancedBackupSettingArray{
 * 				&backup.PlanAdvancedBackupSettingArgs{
 * 					BackupOptions: pulumi.StringMap{
 * 						"WindowsVSS": pulumi.String("enabled"),
 * 					},
 * 					ResourceType: pulumi.String("EC2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Plan;
 * import com.pulumi.aws.backup.PlanArgs;
 * import com.pulumi.aws.backup.inputs.PlanRuleArgs;
 * import com.pulumi.aws.backup.inputs.PlanRuleLifecycleArgs;
 * import com.pulumi.aws.backup.inputs.PlanAdvancedBackupSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Plan("example", PlanArgs.builder()
 *             .name("my_example_backup_plan")
 *             .rules(PlanRuleArgs.builder()
 *                 .ruleName("my_example_backup_rule")
 *                 .targetVaultName(test.name())
 *                 .schedule("cron(0 12 * * ? *)")
 *                 .lifecycle(PlanRuleLifecycleArgs.builder()
 *                     .deleteAfter(14)
 *                     .build())
 *                 .build())
 *             .advancedBackupSettings(PlanAdvancedBackupSettingArgs.builder()
 *                 .backupOptions(Map.of("WindowsVSS", "enabled"))
 *                 .resourceType("EC2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:backup:Plan
 *     properties:
 *       name: my_example_backup_plan
 *       rules:
 *         - ruleName: my_example_backup_rule
 *           targetVaultName: ${test.name}
 *           schedule: cron(0 12 * * ? *)
 *           lifecycle:
 *             deleteAfter: 14
 *       advancedBackupSettings:
 *         - backupOptions:
 *             WindowsVSS: enabled
 *           resourceType: EC2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup Plan using the `id`. For example:
 * ```sh
 * $ pulumi import aws:backup/plan:Plan test <id>
 * ```
 * @property advancedBackupSettings An object that specifies backup options for each resource type.
 * @property name The display name of a backup plan.
 * @property rules A rule object that specifies a scheduled task that is used to back up a selection of resources.
 * @property tags Metadata that you can assign to help organize the plans you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PlanArgs(
    public val advancedBackupSettings: Output<List<PlanAdvancedBackupSettingArgs>>? = null,
    public val name: Output<String>? = null,
    public val rules: Output<List<PlanRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.PlanArgs> {
    override fun toJava(): com.pulumi.aws.backup.PlanArgs = com.pulumi.aws.backup.PlanArgs.builder()
        .advancedBackupSettings(
            advancedBackupSettings?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [PlanArgs].
 */
@PulumiTagMarker
public class PlanArgsBuilder internal constructor() {
    private var advancedBackupSettings: Output<List<PlanAdvancedBackupSettingArgs>>? = null

    private var name: Output<String>? = null

    private var rules: Output<List<PlanRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value An object that specifies backup options for each resource type.
     */
    @JvmName("ljfrrebejlmrwftx")
    public suspend fun advancedBackupSettings(`value`: Output<List<PlanAdvancedBackupSettingArgs>>) {
        this.advancedBackupSettings = value
    }

    @JvmName("fhitkcjioflwpfve")
    public suspend fun advancedBackupSettings(vararg values: Output<PlanAdvancedBackupSettingArgs>) {
        this.advancedBackupSettings = Output.all(values.asList())
    }

    /**
     * @param values An object that specifies backup options for each resource type.
     */
    @JvmName("kdncgfgetgfhojyf")
    public suspend fun advancedBackupSettings(values: List<Output<PlanAdvancedBackupSettingArgs>>) {
        this.advancedBackupSettings = Output.all(values)
    }

    /**
     * @param value The display name of a backup plan.
     */
    @JvmName("irkttjhvwnruuvba")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("fopbjufnceoywrmh")
    public suspend fun rules(`value`: Output<List<PlanRuleArgs>>) {
        this.rules = value
    }

    @JvmName("xhsutsdvfdyocfsg")
    public suspend fun rules(vararg values: Output<PlanRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("iyvhmfsrtmwliqsp")
    public suspend fun rules(values: List<Output<PlanRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Metadata that you can assign to help organize the plans you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eyeemeyvdqaqwadl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An object that specifies backup options for each resource type.
     */
    @JvmName("googbersfcyjymrq")
    public suspend fun advancedBackupSettings(`value`: List<PlanAdvancedBackupSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedBackupSettings = mapped
    }

    /**
     * @param argument An object that specifies backup options for each resource type.
     */
    @JvmName("japyarmrdqmtauar")
    public suspend fun advancedBackupSettings(argument: List<suspend PlanAdvancedBackupSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PlanAdvancedBackupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedBackupSettings = mapped
    }

    /**
     * @param argument An object that specifies backup options for each resource type.
     */
    @JvmName("uoodrjsfcfsyiipm")
    public suspend fun advancedBackupSettings(vararg argument: suspend PlanAdvancedBackupSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PlanAdvancedBackupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedBackupSettings = mapped
    }

    /**
     * @param argument An object that specifies backup options for each resource type.
     */
    @JvmName("daftueqkgnkhvssf")
    public suspend fun advancedBackupSettings(argument: suspend PlanAdvancedBackupSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PlanAdvancedBackupSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.advancedBackupSettings = mapped
    }

    /**
     * @param values An object that specifies backup options for each resource type.
     */
    @JvmName("nurykvfdksaeiwbc")
    public suspend fun advancedBackupSettings(vararg values: PlanAdvancedBackupSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advancedBackupSettings = mapped
    }

    /**
     * @param value The display name of a backup plan.
     */
    @JvmName("sqwcvspvgpfjdcnp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("arojhvjftskvuvcr")
    public suspend fun rules(`value`: List<PlanRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("ohkwsjxxnydqutjj")
    public suspend fun rules(argument: List<suspend PlanRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PlanRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("dakwccegatrpvxsw")
    public suspend fun rules(vararg argument: suspend PlanRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PlanRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("uuqweixulrmvsrdg")
    public suspend fun rules(argument: suspend PlanRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PlanRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("dpxacnptlerlwyje")
    public suspend fun rules(vararg values: PlanRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the plans you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mkgujfkrxepvqgga")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the plans you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hcpgubgfxjnuistn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PlanArgs = PlanArgs(
        advancedBackupSettings = advancedBackupSettings,
        name = name,
        rules = rules,
        tags = tags,
    )
}
