@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [RegionSettings].
 */
@PulumiTagMarker
public class RegionSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegionSettingsArgs = RegionSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegionSettingsArgsBuilder.() -> Unit) {
        val builder = RegionSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegionSettings {
        val builtJavaResource = com.pulumi.aws.backup.RegionSettings(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegionSettings(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup Region Settings resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.backup.RegionSettings("test", {
 *     resourceTypeOptInPreference: {
 *         Aurora: true,
 *         DocumentDB: true,
 *         DynamoDB: true,
 *         EBS: true,
 *         EC2: true,
 *         EFS: true,
 *         FSx: true,
 *         Neptune: true,
 *         RDS: true,
 *         "Storage Gateway": true,
 *         VirtualMachine: true,
 *     },
 *     resourceTypeManagementPreference: {
 *         DynamoDB: true,
 *         EFS: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.backup.RegionSettings("test",
 *     resource_type_opt_in_preference={
 *         "Aurora": True,
 *         "DocumentDB": True,
 *         "DynamoDB": True,
 *         "EBS": True,
 *         "EC2": True,
 *         "EFS": True,
 *         "FSx": True,
 *         "Neptune": True,
 *         "RDS": True,
 *         "Storage Gateway": True,
 *         "VirtualMachine": True,
 *     },
 *     resource_type_management_preference={
 *         "DynamoDB": True,
 *         "EFS": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Backup.RegionSettings("test", new()
 *     {
 *         ResourceTypeOptInPreference =
 *         {
 *             { "Aurora", true },
 *             { "DocumentDB", true },
 *             { "DynamoDB", true },
 *             { "EBS", true },
 *             { "EC2", true },
 *             { "EFS", true },
 *             { "FSx", true },
 *             { "Neptune", true },
 *             { "RDS", true },
 *             { "Storage Gateway", true },
 *             { "VirtualMachine", true },
 *         },
 *         ResourceTypeManagementPreference =
 *         {
 *             { "DynamoDB", true },
 *             { "EFS", true },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewRegionSettings(ctx, "test", &backup.RegionSettingsArgs{
 * 			ResourceTypeOptInPreference: pulumi.BoolMap{
 * 				"Aurora":          pulumi.Bool(true),
 * 				"DocumentDB":      pulumi.Bool(true),
 * 				"DynamoDB":        pulumi.Bool(true),
 * 				"EBS":             pulumi.Bool(true),
 * 				"EC2":             pulumi.Bool(true),
 * 				"EFS":             pulumi.Bool(true),
 * 				"FSx":             pulumi.Bool(true),
 * 				"Neptune":         pulumi.Bool(true),
 * 				"RDS":             pulumi.Bool(true),
 * 				"Storage Gateway": pulumi.Bool(true),
 * 				"VirtualMachine":  pulumi.Bool(true),
 * 			},
 * 			ResourceTypeManagementPreference: pulumi.BoolMap{
 * 				"DynamoDB": pulumi.Bool(true),
 * 				"EFS":      pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.RegionSettings;
 * import com.pulumi.aws.backup.RegionSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RegionSettings("test", RegionSettingsArgs.builder()
 *             .resourceTypeOptInPreference(Map.ofEntries(
 *                 Map.entry("Aurora", true),
 *                 Map.entry("DocumentDB", true),
 *                 Map.entry("DynamoDB", true),
 *                 Map.entry("EBS", true),
 *                 Map.entry("EC2", true),
 *                 Map.entry("EFS", true),
 *                 Map.entry("FSx", true),
 *                 Map.entry("Neptune", true),
 *                 Map.entry("RDS", true),
 *                 Map.entry("Storage Gateway", true),
 *                 Map.entry("VirtualMachine", true)
 *             ))
 *             .resourceTypeManagementPreference(Map.ofEntries(
 *                 Map.entry("DynamoDB", true),
 *                 Map.entry("EFS", true)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:backup:RegionSettings
 *     properties:
 *       resourceTypeOptInPreference:
 *         Aurora: true
 *         DocumentDB: true
 *         DynamoDB: true
 *         EBS: true
 *         EC2: true
 *         EFS: true
 *         FSx: true
 *         Neptune: true
 *         RDS: true
 *         Storage Gateway: true
 *         VirtualMachine: true
 *       resourceTypeManagementPreference:
 *         DynamoDB: true
 *         EFS: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup Region Settings using the `region`. For example:
 * ```sh
 * $ pulumi import aws:backup/regionSettings:RegionSettings test us-west-2
 * ```
 */
public class RegionSettings internal constructor(
    override val javaResource: com.pulumi.aws.backup.RegionSettings,
) : KotlinCustomResource(javaResource, RegionSettingsMapper) {
    /**
     * A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
     */
    public val resourceTypeManagementPreference: Output<Map<String, Boolean>>
        get() = javaResource.resourceTypeManagementPreference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A map of services along with the opt-in preferences for the Region.
     */
    public val resourceTypeOptInPreference: Output<Map<String, Boolean>>
        get() = javaResource.resourceTypeOptInPreference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RegionSettingsMapper : ResourceMapper<RegionSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.RegionSettings::class == javaResource::class

    override fun map(javaResource: Resource): RegionSettings = RegionSettings(
        javaResource as
            com.pulumi.aws.backup.RegionSettings,
    )
}

/**
 * @see [RegionSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegionSettings].
 */
public suspend fun regionSettings(
    name: String,
    block: suspend RegionSettingsResourceBuilder.() -> Unit,
): RegionSettings {
    val builder = RegionSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegionSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun regionSettings(name: String): RegionSettings {
    val builder = RegionSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
