@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.RegionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup Region Settings resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.backup.RegionSettings("test", {
 *     resourceTypeOptInPreference: {
 *         Aurora: true,
 *         DocumentDB: true,
 *         DynamoDB: true,
 *         EBS: true,
 *         EC2: true,
 *         EFS: true,
 *         FSx: true,
 *         Neptune: true,
 *         RDS: true,
 *         "Storage Gateway": true,
 *         VirtualMachine: true,
 *     },
 *     resourceTypeManagementPreference: {
 *         DynamoDB: true,
 *         EFS: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.backup.RegionSettings("test",
 *     resource_type_opt_in_preference={
 *         "Aurora": True,
 *         "DocumentDB": True,
 *         "DynamoDB": True,
 *         "EBS": True,
 *         "EC2": True,
 *         "EFS": True,
 *         "FSx": True,
 *         "Neptune": True,
 *         "RDS": True,
 *         "Storage Gateway": True,
 *         "VirtualMachine": True,
 *     },
 *     resource_type_management_preference={
 *         "DynamoDB": True,
 *         "EFS": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Backup.RegionSettings("test", new()
 *     {
 *         ResourceTypeOptInPreference =
 *         {
 *             { "Aurora", true },
 *             { "DocumentDB", true },
 *             { "DynamoDB", true },
 *             { "EBS", true },
 *             { "EC2", true },
 *             { "EFS", true },
 *             { "FSx", true },
 *             { "Neptune", true },
 *             { "RDS", true },
 *             { "Storage Gateway", true },
 *             { "VirtualMachine", true },
 *         },
 *         ResourceTypeManagementPreference =
 *         {
 *             { "DynamoDB", true },
 *             { "EFS", true },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewRegionSettings(ctx, "test", &backup.RegionSettingsArgs{
 * 			ResourceTypeOptInPreference: pulumi.BoolMap{
 * 				"Aurora":          pulumi.Bool(true),
 * 				"DocumentDB":      pulumi.Bool(true),
 * 				"DynamoDB":        pulumi.Bool(true),
 * 				"EBS":             pulumi.Bool(true),
 * 				"EC2":             pulumi.Bool(true),
 * 				"EFS":             pulumi.Bool(true),
 * 				"FSx":             pulumi.Bool(true),
 * 				"Neptune":         pulumi.Bool(true),
 * 				"RDS":             pulumi.Bool(true),
 * 				"Storage Gateway": pulumi.Bool(true),
 * 				"VirtualMachine":  pulumi.Bool(true),
 * 			},
 * 			ResourceTypeManagementPreference: pulumi.BoolMap{
 * 				"DynamoDB": pulumi.Bool(true),
 * 				"EFS":      pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.RegionSettings;
 * import com.pulumi.aws.backup.RegionSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RegionSettings("test", RegionSettingsArgs.builder()
 *             .resourceTypeOptInPreference(Map.ofEntries(
 *                 Map.entry("Aurora", true),
 *                 Map.entry("DocumentDB", true),
 *                 Map.entry("DynamoDB", true),
 *                 Map.entry("EBS", true),
 *                 Map.entry("EC2", true),
 *                 Map.entry("EFS", true),
 *                 Map.entry("FSx", true),
 *                 Map.entry("Neptune", true),
 *                 Map.entry("RDS", true),
 *                 Map.entry("Storage Gateway", true),
 *                 Map.entry("VirtualMachine", true)
 *             ))
 *             .resourceTypeManagementPreference(Map.ofEntries(
 *                 Map.entry("DynamoDB", true),
 *                 Map.entry("EFS", true)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:backup:RegionSettings
 *     properties:
 *       resourceTypeOptInPreference:
 *         Aurora: true
 *         DocumentDB: true
 *         DynamoDB: true
 *         EBS: true
 *         EC2: true
 *         EFS: true
 *         FSx: true
 *         Neptune: true
 *         RDS: true
 *         Storage Gateway: true
 *         VirtualMachine: true
 *       resourceTypeManagementPreference:
 *         DynamoDB: true
 *         EFS: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup Region Settings using the `region`. For example:
 * ```sh
 * $ pulumi import aws:backup/regionSettings:RegionSettings test us-west-2
 * ```
 * @property resourceTypeManagementPreference A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
 * @property resourceTypeOptInPreference A map of services along with the opt-in preferences for the Region.
 */
public data class RegionSettingsArgs(
    public val resourceTypeManagementPreference: Output<Map<String, Boolean>>? = null,
    public val resourceTypeOptInPreference: Output<Map<String, Boolean>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.RegionSettingsArgs> {
    override fun toJava(): com.pulumi.aws.backup.RegionSettingsArgs =
        com.pulumi.aws.backup.RegionSettingsArgs.builder()
            .resourceTypeManagementPreference(
                resourceTypeManagementPreference?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .resourceTypeOptInPreference(
                resourceTypeOptInPreference?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RegionSettingsArgs].
 */
@PulumiTagMarker
public class RegionSettingsArgsBuilder internal constructor() {
    private var resourceTypeManagementPreference: Output<Map<String, Boolean>>? = null

    private var resourceTypeOptInPreference: Output<Map<String, Boolean>>? = null

    /**
     * @param value A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
     */
    @JvmName("qhrtjfxomdkeycjx")
    public suspend fun resourceTypeManagementPreference(`value`: Output<Map<String, Boolean>>) {
        this.resourceTypeManagementPreference = value
    }

    /**
     * @param value A map of services along with the opt-in preferences for the Region.
     */
    @JvmName("vikbvnkhtoqgbiok")
    public suspend fun resourceTypeOptInPreference(`value`: Output<Map<String, Boolean>>) {
        this.resourceTypeOptInPreference = value
    }

    /**
     * @param value A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
     */
    @JvmName("afssmyccncqshtqd")
    public suspend fun resourceTypeManagementPreference(`value`: Map<String, Boolean>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypeManagementPreference = mapped
    }

    /**
     * @param values A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
     */
    @JvmName("vcaksppvdmgxnvjw")
    public fun resourceTypeManagementPreference(vararg values: Pair<String, Boolean>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypeManagementPreference = mapped
    }

    /**
     * @param value A map of services along with the opt-in preferences for the Region.
     */
    @JvmName("irkdlvpcumegtnec")
    public suspend fun resourceTypeOptInPreference(`value`: Map<String, Boolean>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypeOptInPreference = mapped
    }

    /**
     * @param values A map of services along with the opt-in preferences for the Region.
     */
    @JvmName("wfdiictrygpikvcy")
    public fun resourceTypeOptInPreference(vararg values: Pair<String, Boolean>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypeOptInPreference = mapped
    }

    internal fun build(): RegionSettingsArgs = RegionSettingsArgs(
        resourceTypeManagementPreference = resourceTypeManagementPreference,
        resourceTypeOptInPreference = resourceTypeOptInPreference,
    )
}
