@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.ReportPlanArgs.builder
import com.pulumi.aws.backup.kotlin.inputs.ReportPlanReportDeliveryChannelArgs
import com.pulumi.aws.backup.kotlin.inputs.ReportPlanReportDeliveryChannelArgsBuilder
import com.pulumi.aws.backup.kotlin.inputs.ReportPlanReportSettingArgs
import com.pulumi.aws.backup.kotlin.inputs.ReportPlanReportSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup Report Plan resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.backup.ReportPlan("example", {
 *     name: "example_name",
 *     description: "example description",
 *     reportDeliveryChannel: {
 *         formats: [
 *             "CSV",
 *             "JSON",
 *         ],
 *         s3BucketName: "example-bucket-name",
 *     },
 *     reportSetting: {
 *         reportTemplate: "RESTORE_JOB_REPORT",
 *     },
 *     tags: {
 *         Name: "Example Report Plan",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.backup.ReportPlan("example",
 *     name="example_name",
 *     description="example description",
 *     report_delivery_channel={
 *         "formats": [
 *             "CSV",
 *             "JSON",
 *         ],
 *         "s3_bucket_name": "example-bucket-name",
 *     },
 *     report_setting={
 *         "report_template": "RESTORE_JOB_REPORT",
 *     },
 *     tags={
 *         "Name": "Example Report Plan",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Backup.ReportPlan("example", new()
 *     {
 *         Name = "example_name",
 *         Description = "example description",
 *         ReportDeliveryChannel = new Aws.Backup.Inputs.ReportPlanReportDeliveryChannelArgs
 *         {
 *             Formats = new[]
 *             {
 *                 "CSV",
 *                 "JSON",
 *             },
 *             S3BucketName = "example-bucket-name",
 *         },
 *         ReportSetting = new Aws.Backup.Inputs.ReportPlanReportSettingArgs
 *         {
 *             ReportTemplate = "RESTORE_JOB_REPORT",
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Report Plan" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewReportPlan(ctx, "example", &backup.ReportPlanArgs{
 * 			Name:        pulumi.String("example_name"),
 * 			Description: pulumi.String("example description"),
 * 			ReportDeliveryChannel: &backup.ReportPlanReportDeliveryChannelArgs{
 * 				Formats: pulumi.StringArray{
 * 					pulumi.String("CSV"),
 * 					pulumi.String("JSON"),
 * 				},
 * 				S3BucketName: pulumi.String("example-bucket-name"),
 * 			},
 * 			ReportSetting: &backup.ReportPlanReportSettingArgs{
 * 				ReportTemplate: pulumi.String("RESTORE_JOB_REPORT"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Report Plan"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.ReportPlan;
 * import com.pulumi.aws.backup.ReportPlanArgs;
 * import com.pulumi.aws.backup.inputs.ReportPlanReportDeliveryChannelArgs;
 * import com.pulumi.aws.backup.inputs.ReportPlanReportSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReportPlan("example", ReportPlanArgs.builder()
 *             .name("example_name")
 *             .description("example description")
 *             .reportDeliveryChannel(ReportPlanReportDeliveryChannelArgs.builder()
 *                 .formats(
 *                     "CSV",
 *                     "JSON")
 *                 .s3BucketName("example-bucket-name")
 *                 .build())
 *             .reportSetting(ReportPlanReportSettingArgs.builder()
 *                 .reportTemplate("RESTORE_JOB_REPORT")
 *                 .build())
 *             .tags(Map.of("Name", "Example Report Plan"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:backup:ReportPlan
 *     properties:
 *       name: example_name
 *       description: example description
 *       reportDeliveryChannel:
 *         formats:
 *           - CSV
 *           - JSON
 *         s3BucketName: example-bucket-name
 *       reportSetting:
 *         reportTemplate: RESTORE_JOB_REPORT
 *       tags:
 *         Name: Example Report Plan
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup Report Plan using the `id` which corresponds to the name of the Backup Report Plan. For example:
 * ```sh
 * $ pulumi import aws:backup/reportPlan:ReportPlan test <id>
 * ```
 * @property description The description of the report plan with a maximum of 1,024 characters
 * @property name The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
 * @property reportDeliveryChannel An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
 * @property reportSetting An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
 * @property tags Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ReportPlanArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val reportDeliveryChannel: Output<ReportPlanReportDeliveryChannelArgs>? = null,
    public val reportSetting: Output<ReportPlanReportSettingArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.ReportPlanArgs> {
    override fun toJava(): com.pulumi.aws.backup.ReportPlanArgs =
        com.pulumi.aws.backup.ReportPlanArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .reportDeliveryChannel(
                reportDeliveryChannel?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .reportSetting(reportSetting?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReportPlanArgs].
 */
@PulumiTagMarker
public class ReportPlanArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var reportDeliveryChannel: Output<ReportPlanReportDeliveryChannelArgs>? = null

    private var reportSetting: Output<ReportPlanReportSettingArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the report plan with a maximum of 1,024 characters
     */
    @JvmName("lcuyntqnejwrwvnv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    @JvmName("qlboklrhcbtemjpt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
     */
    @JvmName("eicfnsnmibtgewxi")
    public suspend fun reportDeliveryChannel(`value`: Output<ReportPlanReportDeliveryChannelArgs>) {
        this.reportDeliveryChannel = value
    }

    /**
     * @param value An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
     */
    @JvmName("ewjvfyaeiiobwgfr")
    public suspend fun reportSetting(`value`: Output<ReportPlanReportSettingArgs>) {
        this.reportSetting = value
    }

    /**
     * @param value Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ufohjrweyudyuvns")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the report plan with a maximum of 1,024 characters
     */
    @JvmName("sjadlqqitsylvkdv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    @JvmName("jhrxbdpduxjadqbl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
     */
    @JvmName("jgyfhdvkpkovwmmc")
    public suspend fun reportDeliveryChannel(`value`: ReportPlanReportDeliveryChannelArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportDeliveryChannel = mapped
    }

    /**
     * @param argument An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
     */
    @JvmName("wojsgcgqtydeaboo")
    public suspend fun reportDeliveryChannel(argument: suspend ReportPlanReportDeliveryChannelArgsBuilder.() -> Unit) {
        val toBeMapped = ReportPlanReportDeliveryChannelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reportDeliveryChannel = mapped
    }

    /**
     * @param value An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
     */
    @JvmName("cubbcsaetvxrasuu")
    public suspend fun reportSetting(`value`: ReportPlanReportSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportSetting = mapped
    }

    /**
     * @param argument An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
     */
    @JvmName("ckhdccokohpspttt")
    public suspend fun reportSetting(argument: suspend ReportPlanReportSettingArgsBuilder.() -> Unit) {
        val toBeMapped = ReportPlanReportSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reportSetting = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("atfvkcnhkecrifwg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("avtraejtnrolseew")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReportPlanArgs = ReportPlanArgs(
        description = description,
        name = name,
        reportDeliveryChannel = reportDeliveryChannel,
        reportSetting = reportSetting,
        tags = tags,
    )
}
