@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.VaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup vault resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.backup.Vault("example", {
 *     name: "example_backup_vault",
 *     kmsKeyArn: exampleAwsKmsKey.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.backup.Vault("example",
 *     name="example_backup_vault",
 *     kms_key_arn=example_aws_kms_key["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Backup.Vault("example", new()
 *     {
 *         Name = "example_backup_vault",
 *         KmsKeyArn = exampleAwsKmsKey.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewVault(ctx, "example", &backup.VaultArgs{
 * 			Name:      pulumi.String("example_backup_vault"),
 * 			KmsKeyArn: pulumi.Any(exampleAwsKmsKey.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Vault;
 * import com.pulumi.aws.backup.VaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vault("example", VaultArgs.builder()
 *             .name("example_backup_vault")
 *             .kmsKeyArn(exampleAwsKmsKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:backup:Vault
 *     properties:
 *       name: example_backup_vault
 *       kmsKeyArn: ${exampleAwsKmsKey.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup vault using the `name`. For example:
 * ```sh
 * $ pulumi import aws:backup/vault:Vault test-vault TestVault
 * ```
 * @property forceDestroy A boolean that indicates that all recovery points stored in the vault are deleted so that the vault can be destroyed without error.
 * @property kmsKeyArn The server-side encryption key that is used to protect your backups.
 * @property name Name of the backup vault to create.
 * @property tags Metadata that you can assign to help organize the resources that you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VaultArgs(
    public val forceDestroy: Output<Boolean>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.VaultArgs> {
    override fun toJava(): com.pulumi.aws.backup.VaultArgs = com.pulumi.aws.backup.VaultArgs.builder()
        .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
        .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [VaultArgs].
 */
@PulumiTagMarker
public class VaultArgsBuilder internal constructor() {
    private var forceDestroy: Output<Boolean>? = null

    private var kmsKeyArn: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A boolean that indicates that all recovery points stored in the vault are deleted so that the vault can be destroyed without error.
     */
    @JvmName("orivckypulvgcdhr")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value The server-side encryption key that is used to protect your backups.
     */
    @JvmName("usgcuylfcctjdyrr")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Name of the backup vault to create.
     */
    @JvmName("makcjukgdefriiep")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Metadata that you can assign to help organize the resources that you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vduuwnmxwhxjrskk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A boolean that indicates that all recovery points stored in the vault are deleted so that the vault can be destroyed without error.
     */
    @JvmName("yybyervglcftcejx")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value The server-side encryption key that is used to protect your backups.
     */
    @JvmName("lhprrlgcwjnbiegl")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Name of the backup vault to create.
     */
    @JvmName("kqlytkltsvaivbis")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the resources that you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mugknthxyduoeiej")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the resources that you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wqysktqhqmkepgcr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VaultArgs = VaultArgs(
        forceDestroy = forceDestroy,
        kmsKeyArn = kmsKeyArn,
        name = name,
        tags = tags,
    )
}
