@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VaultLockConfiguration].
 */
@PulumiTagMarker
public class VaultLockConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultLockConfigurationArgs = VaultLockConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultLockConfigurationArgsBuilder.() -> Unit) {
        val builder = VaultLockConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VaultLockConfiguration {
        val builtJavaResource = com.pulumi.aws.backup.VaultLockConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VaultLockConfiguration(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup vault lock configuration resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.backup.VaultLockConfiguration("test", {
 *     backupVaultName: "example_backup_vault",
 *     changeableForDays: 3,
 *     maxRetentionDays: 1200,
 *     minRetentionDays: 7,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.backup.VaultLockConfiguration("test",
 *     backup_vault_name="example_backup_vault",
 *     changeable_for_days=3,
 *     max_retention_days=1200,
 *     min_retention_days=7)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Backup.VaultLockConfiguration("test", new()
 *     {
 *         BackupVaultName = "example_backup_vault",
 *         ChangeableForDays = 3,
 *         MaxRetentionDays = 1200,
 *         MinRetentionDays = 7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewVaultLockConfiguration(ctx, "test", &backup.VaultLockConfigurationArgs{
 * 			BackupVaultName:   pulumi.String("example_backup_vault"),
 * 			ChangeableForDays: pulumi.Int(3),
 * 			MaxRetentionDays:  pulumi.Int(1200),
 * 			MinRetentionDays:  pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.VaultLockConfiguration;
 * import com.pulumi.aws.backup.VaultLockConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new VaultLockConfiguration("test", VaultLockConfigurationArgs.builder()
 *             .backupVaultName("example_backup_vault")
 *             .changeableForDays(3)
 *             .maxRetentionDays(1200)
 *             .minRetentionDays(7)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:backup:VaultLockConfiguration
 *     properties:
 *       backupVaultName: example_backup_vault
 *       changeableForDays: 3
 *       maxRetentionDays: 1200
 *       minRetentionDays: 7
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup vault lock configuration using the `name`. For example:
 * ```sh
 * $ pulumi import aws:backup/vaultLockConfiguration:VaultLockConfiguration test TestVault
 * ```
 */
public class VaultLockConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.backup.VaultLockConfiguration,
) : KotlinCustomResource(javaResource, VaultLockConfigurationMapper) {
    /**
     * The ARN of the vault.
     */
    public val backupVaultArn: Output<String>
        get() = javaResource.backupVaultArn().applyValue({ args0 -> args0 })

    /**
     * Name of the backup vault to add a lock configuration for.
     */
    public val backupVaultName: Output<String>
        get() = javaResource.backupVaultName().applyValue({ args0 -> args0 })

    /**
     * The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
     */
    public val changeableForDays: Output<Int>?
        get() = javaResource.changeableForDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum retention period that the vault retains its recovery points.
     */
    public val maxRetentionDays: Output<Int>?
        get() = javaResource.maxRetentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum retention period that the vault retains its recovery points.
     */
    public val minRetentionDays: Output<Int>?
        get() = javaResource.minRetentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VaultLockConfigurationMapper : ResourceMapper<VaultLockConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.VaultLockConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): VaultLockConfiguration =
        VaultLockConfiguration(javaResource as com.pulumi.aws.backup.VaultLockConfiguration)
}

/**
 * @see [VaultLockConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VaultLockConfiguration].
 */
public suspend fun vaultLockConfiguration(
    name: String,
    block: suspend VaultLockConfigurationResourceBuilder.() -> Unit,
): VaultLockConfiguration {
    val builder = VaultLockConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VaultLockConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vaultLockConfiguration(name: String): VaultLockConfiguration {
    val builder = VaultLockConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
