@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.VaultLockConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup vault lock configuration resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.backup.VaultLockConfiguration("test", {
 *     backupVaultName: "example_backup_vault",
 *     changeableForDays: 3,
 *     maxRetentionDays: 1200,
 *     minRetentionDays: 7,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.backup.VaultLockConfiguration("test",
 *     backup_vault_name="example_backup_vault",
 *     changeable_for_days=3,
 *     max_retention_days=1200,
 *     min_retention_days=7)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Backup.VaultLockConfiguration("test", new()
 *     {
 *         BackupVaultName = "example_backup_vault",
 *         ChangeableForDays = 3,
 *         MaxRetentionDays = 1200,
 *         MinRetentionDays = 7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := backup.NewVaultLockConfiguration(ctx, "test", &backup.VaultLockConfigurationArgs{
 * 			BackupVaultName:   pulumi.String("example_backup_vault"),
 * 			ChangeableForDays: pulumi.Int(3),
 * 			MaxRetentionDays:  pulumi.Int(1200),
 * 			MinRetentionDays:  pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.VaultLockConfiguration;
 * import com.pulumi.aws.backup.VaultLockConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new VaultLockConfiguration("test", VaultLockConfigurationArgs.builder()
 *             .backupVaultName("example_backup_vault")
 *             .changeableForDays(3)
 *             .maxRetentionDays(1200)
 *             .minRetentionDays(7)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:backup:VaultLockConfiguration
 *     properties:
 *       backupVaultName: example_backup_vault
 *       changeableForDays: 3
 *       maxRetentionDays: 1200
 *       minRetentionDays: 7
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup vault lock configuration using the `name`. For example:
 * ```sh
 * $ pulumi import aws:backup/vaultLockConfiguration:VaultLockConfiguration test TestVault
 * ```
 * @property backupVaultName Name of the backup vault to add a lock configuration for.
 * @property changeableForDays The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
 * @property maxRetentionDays The maximum retention period that the vault retains its recovery points.
 * @property minRetentionDays The minimum retention period that the vault retains its recovery points.
 */
public data class VaultLockConfigurationArgs(
    public val backupVaultName: Output<String>? = null,
    public val changeableForDays: Output<Int>? = null,
    public val maxRetentionDays: Output<Int>? = null,
    public val minRetentionDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.VaultLockConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.backup.VaultLockConfigurationArgs =
        com.pulumi.aws.backup.VaultLockConfigurationArgs.builder()
            .backupVaultName(backupVaultName?.applyValue({ args0 -> args0 }))
            .changeableForDays(changeableForDays?.applyValue({ args0 -> args0 }))
            .maxRetentionDays(maxRetentionDays?.applyValue({ args0 -> args0 }))
            .minRetentionDays(minRetentionDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultLockConfigurationArgs].
 */
@PulumiTagMarker
public class VaultLockConfigurationArgsBuilder internal constructor() {
    private var backupVaultName: Output<String>? = null

    private var changeableForDays: Output<Int>? = null

    private var maxRetentionDays: Output<Int>? = null

    private var minRetentionDays: Output<Int>? = null

    /**
     * @param value Name of the backup vault to add a lock configuration for.
     */
    @JvmName("pisskdqgeiukmxmh")
    public suspend fun backupVaultName(`value`: Output<String>) {
        this.backupVaultName = value
    }

    /**
     * @param value The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
     */
    @JvmName("vpjswrauirpfcbte")
    public suspend fun changeableForDays(`value`: Output<Int>) {
        this.changeableForDays = value
    }

    /**
     * @param value The maximum retention period that the vault retains its recovery points.
     */
    @JvmName("hyvrplletapohwwa")
    public suspend fun maxRetentionDays(`value`: Output<Int>) {
        this.maxRetentionDays = value
    }

    /**
     * @param value The minimum retention period that the vault retains its recovery points.
     */
    @JvmName("pvunvnbsrmtiotad")
    public suspend fun minRetentionDays(`value`: Output<Int>) {
        this.minRetentionDays = value
    }

    /**
     * @param value Name of the backup vault to add a lock configuration for.
     */
    @JvmName("nnpetvkqlceqdfbk")
    public suspend fun backupVaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupVaultName = mapped
    }

    /**
     * @param value The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
     */
    @JvmName("iedinbxjogqkcooi")
    public suspend fun changeableForDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeableForDays = mapped
    }

    /**
     * @param value The maximum retention period that the vault retains its recovery points.
     */
    @JvmName("lggbhqavrgnhogvm")
    public suspend fun maxRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetentionDays = mapped
    }

    /**
     * @param value The minimum retention period that the vault retains its recovery points.
     */
    @JvmName("oxjdxnicqqtybldc")
    public suspend fun minRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minRetentionDays = mapped
    }

    internal fun build(): VaultLockConfigurationArgs = VaultLockConfigurationArgs(
        backupVaultName = backupVaultName,
        changeableForDays = changeableForDays,
        maxRetentionDays = maxRetentionDays,
        minRetentionDays = minRetentionDays,
    )
}
