@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VaultPolicy].
 */
@PulumiTagMarker
public class VaultPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultPolicyArgs = VaultPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultPolicyArgsBuilder.() -> Unit) {
        val builder = VaultPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VaultPolicy {
        val builtJavaResource = com.pulumi.aws.backup.VaultPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VaultPolicy(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup vault policy resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleVault = new aws.backup.Vault("example", {name: "example"});
 * const example = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["*"],
 *         }],
 *         actions: [
 *             "backup:DescribeBackupVault",
 *             "backup:DeleteBackupVault",
 *             "backup:PutBackupVaultAccessPolicy",
 *             "backup:DeleteBackupVaultAccessPolicy",
 *             "backup:GetBackupVaultAccessPolicy",
 *             "backup:StartBackupJob",
 *             "backup:GetBackupVaultNotifications",
 *             "backup:PutBackupVaultNotifications",
 *         ],
 *         resources: [exampleVault&#46;arn],
 *     }],
 * });
 * const exampleVaultPolicy = new aws.backup.VaultPolicy("example", {
 *     backupVaultName: exampleVault.name,
 *     policy: example.apply(example => example.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_vault = aws.backup.Vault("example", name="example")
 * example = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["*"],
 *     }],
 *     "actions": [
 *         "backup:DescribeBackupVault",
 *         "backup:DeleteBackupVault",
 *         "backup:PutBackupVaultAccessPolicy",
 *         "backup:DeleteBackupVaultAccessPolicy",
 *         "backup:GetBackupVaultAccessPolicy",
 *         "backup:StartBackupJob",
 *         "backup:GetBackupVaultNotifications",
 *         "backup:PutBackupVaultNotifications",
 *     ],
 *     "resources": [example_vault&#46;arn],
 * }])
 * example_vault_policy = aws.backup.VaultPolicy("example",
 *     backup_vault_name=example_vault.name,
 *     policy=example.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleVault = new Aws.Backup.Vault("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "backup:DescribeBackupVault",
 *                     "backup:DeleteBackupVault",
 *                     "backup:PutBackupVaultAccessPolicy",
 *                     "backup:DeleteBackupVaultAccessPolicy",
 *                     "backup:GetBackupVaultAccessPolicy",
 *                     "backup:StartBackupJob",
 *                     "backup:GetBackupVaultNotifications",
 *                     "backup:PutBackupVaultNotifications",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleVault.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var exampleVaultPolicy = new Aws.Backup.VaultPolicy("example", new()
 *     {
 *         BackupVaultName = exampleVault.Name,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/backup"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleVault, err := backup.NewVault(ctx, "example", &backup.VaultArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Principals: iam.GetPolicyDocumentStatementPrincipalArray{
 * 						&iam.GetPolicyDocumentStatementPrincipalArgs{
 * 							Type: pulumi.String("AWS"),
 * 							Identifiers: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 						},
 * 					},
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("backup:DescribeBackupVault"),
 * 						pulumi.String("backup:DeleteBackupVault"),
 * 						pulumi.String("backup:PutBackupVaultAccessPolicy"),
 * 						pulumi.String("backup:DeleteBackupVaultAccessPolicy"),
 * 						pulumi.String("backup:GetBackupVaultAccessPolicy"),
 * 						pulumi.String("backup:StartBackupJob"),
 * 						pulumi.String("backup:GetBackupVaultNotifications"),
 * 						pulumi.String("backup:PutBackupVaultNotifications"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						exampleVault.Arn,
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = backup.NewVaultPolicy(ctx, "example", &backup.VaultPolicyArgs{
 * 			BackupVaultName: exampleVault.Name,
 * 			Policy: pulumi.String(example.ApplyT(func(example iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &example.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Vault;
 * import com.pulumi.aws.backup.VaultArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.backup.VaultPolicy;
 * import com.pulumi.aws.backup.VaultPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVault = new Vault("exampleVault", VaultArgs.builder()
 *             .name("example")
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions(
 *                     "backup:DescribeBackupVault",
 *                     "backup:DeleteBackupVault",
 *                     "backup:PutBackupVaultAccessPolicy",
 *                     "backup:DeleteBackupVaultAccessPolicy",
 *                     "backup:GetBackupVaultAccessPolicy",
 *                     "backup:StartBackupJob",
 *                     "backup:GetBackupVaultNotifications",
 *                     "backup:PutBackupVaultNotifications")
 *                 .resources(exampleVault.arn())
 *                 .build())
 *             .build());
 *         var exampleVaultPolicy = new VaultPolicy("exampleVaultPolicy", VaultPolicyArgs.builder()
 *             .backupVaultName(exampleVault.name())
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(example -> example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleVault:
 *     type: aws:backup:Vault
 *     name: example
 *     properties:
 *       name: example
 *   exampleVaultPolicy:
 *     type: aws:backup:VaultPolicy
 *     name: example
 *     properties:
 *       backupVaultName: ${exampleVault.name}
 *       policy: ${example.json}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '*'
 *             actions:
 *               - backup:DescribeBackupVault
 *               - backup:DeleteBackupVault
 *               - backup:PutBackupVaultAccessPolicy
 *               - backup:DeleteBackupVaultAccessPolicy
 *               - backup:GetBackupVaultAccessPolicy
 *               - backup:StartBackupJob
 *               - backup:GetBackupVaultNotifications
 *               - backup:PutBackupVaultNotifications
 *             resources:
 *               - ${exampleVault.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Backup vault policy using the `name`. For example:
 * ```sh
 * $ pulumi import aws:backup/vaultPolicy:VaultPolicy test TestVault
 * ```
 */
public class VaultPolicy internal constructor(
    override val javaResource: com.pulumi.aws.backup.VaultPolicy,
) : KotlinCustomResource(javaResource, VaultPolicyMapper) {
    /**
     * The ARN of the vault.
     */
    public val backupVaultArn: Output<String>
        get() = javaResource.backupVaultArn().applyValue({ args0 -> args0 })

    /**
     * Name of the backup vault to add policy for.
     */
    public val backupVaultName: Output<String>
        get() = javaResource.backupVaultName().applyValue({ args0 -> args0 })

    /**
     * The backup vault access policy document in JSON format.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object VaultPolicyMapper : ResourceMapper<VaultPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.VaultPolicy::class == javaResource::class

    override fun map(javaResource: Resource): VaultPolicy = VaultPolicy(
        javaResource as
            com.pulumi.aws.backup.VaultPolicy,
    )
}

/**
 * @see [VaultPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VaultPolicy].
 */
public suspend fun vaultPolicy(name: String, block: suspend VaultPolicyResourceBuilder.() -> Unit): VaultPolicy {
    val builder = VaultPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VaultPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vaultPolicy(name: String): VaultPolicy {
    val builder = VaultPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
