@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.FrameworkControlScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property complianceResourceIds The ID of the only AWS resource that you want your control scope to contain. Minimum number of 1 item. Maximum number of 100 items.
 * @property complianceResourceTypes Describes whether the control scope includes one or more types of resources, such as EFS or RDS.
 * @property tags The tag key-value pair applied to those AWS resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided.
 */
public data class FrameworkControlScopeArgs(
    public val complianceResourceIds: Output<List<String>>? = null,
    public val complianceResourceTypes: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.FrameworkControlScopeArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.FrameworkControlScopeArgs =
        com.pulumi.aws.backup.inputs.FrameworkControlScopeArgs.builder()
            .complianceResourceIds(complianceResourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .complianceResourceTypes(
                complianceResourceTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FrameworkControlScopeArgs].
 */
@PulumiTagMarker
public class FrameworkControlScopeArgsBuilder internal constructor() {
    private var complianceResourceIds: Output<List<String>>? = null

    private var complianceResourceTypes: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of the only AWS resource that you want your control scope to contain. Minimum number of 1 item. Maximum number of 100 items.
     */
    @JvmName("fnknakoplsxfssif")
    public suspend fun complianceResourceIds(`value`: Output<List<String>>) {
        this.complianceResourceIds = value
    }

    @JvmName("hnhnjwfcbbroqyob")
    public suspend fun complianceResourceIds(vararg values: Output<String>) {
        this.complianceResourceIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of the only AWS resource that you want your control scope to contain. Minimum number of 1 item. Maximum number of 100 items.
     */
    @JvmName("poqbinmoxurrrrek")
    public suspend fun complianceResourceIds(values: List<Output<String>>) {
        this.complianceResourceIds = Output.all(values)
    }

    /**
     * @param value Describes whether the control scope includes one or more types of resources, such as EFS or RDS.
     */
    @JvmName("mrpqmttqahrjrqvh")
    public suspend fun complianceResourceTypes(`value`: Output<List<String>>) {
        this.complianceResourceTypes = value
    }

    @JvmName("axssddevepwbomww")
    public suspend fun complianceResourceTypes(vararg values: Output<String>) {
        this.complianceResourceTypes = Output.all(values.asList())
    }

    /**
     * @param values Describes whether the control scope includes one or more types of resources, such as EFS or RDS.
     */
    @JvmName("pljcwtbhapojlnqc")
    public suspend fun complianceResourceTypes(values: List<Output<String>>) {
        this.complianceResourceTypes = Output.all(values)
    }

    /**
     * @param value The tag key-value pair applied to those AWS resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided.
     */
    @JvmName("opugmesappqvpupl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the only AWS resource that you want your control scope to contain. Minimum number of 1 item. Maximum number of 100 items.
     */
    @JvmName("fkjgghwondnqotnm")
    public suspend fun complianceResourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceResourceIds = mapped
    }

    /**
     * @param values The ID of the only AWS resource that you want your control scope to contain. Minimum number of 1 item. Maximum number of 100 items.
     */
    @JvmName("hlvinfbyhfnnveqa")
    public suspend fun complianceResourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complianceResourceIds = mapped
    }

    /**
     * @param value Describes whether the control scope includes one or more types of resources, such as EFS or RDS.
     */
    @JvmName("akyatfqubgdoscnl")
    public suspend fun complianceResourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceResourceTypes = mapped
    }

    /**
     * @param values Describes whether the control scope includes one or more types of resources, such as EFS or RDS.
     */
    @JvmName("onnihspgprkcgabw")
    public suspend fun complianceResourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complianceResourceTypes = mapped
    }

    /**
     * @param value The tag key-value pair applied to those AWS resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided.
     */
    @JvmName("dtmntlojssalayfu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag key-value pair applied to those AWS resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided.
     */
    @JvmName("bqjsgmqvanvdimll")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FrameworkControlScopeArgs = FrameworkControlScopeArgs(
        complianceResourceIds = complianceResourceIds,
        complianceResourceTypes = complianceResourceTypes,
        tags = tags,
    )
}
