@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.PlanAdvancedBackupSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property backupOptions Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs. Set to `{ WindowsVSS = "enabled" }` to enable Windows VSS backup option and create a VSS Windows backup.
 * @property resourceType The type of AWS resource to be backed up. For VSS Windows backups, the only supported resource type is Amazon EC2. Valid values: `EC2`.
 */
public data class PlanAdvancedBackupSettingArgs(
    public val backupOptions: Output<Map<String, String>>,
    public val resourceType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.PlanAdvancedBackupSettingArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.PlanAdvancedBackupSettingArgs =
        com.pulumi.aws.backup.inputs.PlanAdvancedBackupSettingArgs.builder()
            .backupOptions(
                backupOptions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceType(resourceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlanAdvancedBackupSettingArgs].
 */
@PulumiTagMarker
public class PlanAdvancedBackupSettingArgsBuilder internal constructor() {
    private var backupOptions: Output<Map<String, String>>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs. Set to `{ WindowsVSS = "enabled" }` to enable Windows VSS backup option and create a VSS Windows backup.
     */
    @JvmName("fnypuhojtaqnhsqn")
    public suspend fun backupOptions(`value`: Output<Map<String, String>>) {
        this.backupOptions = value
    }

    /**
     * @param value The type of AWS resource to be backed up. For VSS Windows backups, the only supported resource type is Amazon EC2. Valid values: `EC2`.
     */
    @JvmName("ocgqlrrivadiwlas")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs. Set to `{ WindowsVSS = "enabled" }` to enable Windows VSS backup option and create a VSS Windows backup.
     */
    @JvmName("wqbgkgpnvwecfmqg")
    public suspend fun backupOptions(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupOptions = mapped
    }

    /**
     * @param values Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs. Set to `{ WindowsVSS = "enabled" }` to enable Windows VSS backup option and create a VSS Windows backup.
     */
    @JvmName("krskgtqjubtinofy")
    public fun backupOptions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupOptions = mapped
    }

    /**
     * @param value The type of AWS resource to be backed up. For VSS Windows backups, the only supported resource type is Amazon EC2. Valid values: `EC2`.
     */
    @JvmName("ijnurujodaqxpjuc")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): PlanAdvancedBackupSettingArgs = PlanAdvancedBackupSettingArgs(
        backupOptions = backupOptions ?: throw PulumiNullFieldException("backupOptions"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
