@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.ReportPlanReportDeliveryChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property formats A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
 * @property s3BucketName The unique name of the S3 bucket that receives your reports.
 * @property s3KeyPrefix The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
 */
public data class ReportPlanReportDeliveryChannelArgs(
    public val formats: Output<List<String>>? = null,
    public val s3BucketName: Output<String>,
    public val s3KeyPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.ReportPlanReportDeliveryChannelArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.ReportPlanReportDeliveryChannelArgs =
        com.pulumi.aws.backup.inputs.ReportPlanReportDeliveryChannelArgs.builder()
            .formats(formats?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .s3BucketName(s3BucketName.applyValue({ args0 -> args0 }))
            .s3KeyPrefix(s3KeyPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportPlanReportDeliveryChannelArgs].
 */
@PulumiTagMarker
public class ReportPlanReportDeliveryChannelArgsBuilder internal constructor() {
    private var formats: Output<List<String>>? = null

    private var s3BucketName: Output<String>? = null

    private var s3KeyPrefix: Output<String>? = null

    /**
     * @param value A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
     */
    @JvmName("spoqqmmyytxqrlhs")
    public suspend fun formats(`value`: Output<List<String>>) {
        this.formats = value
    }

    @JvmName("vmhbumjfgwyvadmt")
    public suspend fun formats(vararg values: Output<String>) {
        this.formats = Output.all(values.asList())
    }

    /**
     * @param values A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
     */
    @JvmName("xosisudchskcyxgt")
    public suspend fun formats(values: List<Output<String>>) {
        this.formats = Output.all(values)
    }

    /**
     * @param value The unique name of the S3 bucket that receives your reports.
     */
    @JvmName("rwskcamjwjhkbjgj")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
     */
    @JvmName("rfeoodbrcrafksjn")
    public suspend fun s3KeyPrefix(`value`: Output<String>) {
        this.s3KeyPrefix = value
    }

    /**
     * @param value A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
     */
    @JvmName("tymogcmcikqjvdst")
    public suspend fun formats(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.formats = mapped
    }

    /**
     * @param values A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
     */
    @JvmName("fujpefunmgovjvte")
    public suspend fun formats(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.formats = mapped
    }

    /**
     * @param value The unique name of the S3 bucket that receives your reports.
     */
    @JvmName("wgbpildxigikgfxo")
    public suspend fun s3BucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
     */
    @JvmName("jfuaxfdxvtjydcok")
    public suspend fun s3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KeyPrefix = mapped
    }

    internal fun build(): ReportPlanReportDeliveryChannelArgs = ReportPlanReportDeliveryChannelArgs(
        formats = formats,
        s3BucketName = s3BucketName ?: throw PulumiNullFieldException("s3BucketName"),
        s3KeyPrefix = s3KeyPrefix,
    )
}
