@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.SelectionConditionStringLikeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The key in a key-value pair.
 * @property value The value in a key-value pair.
 */
public data class SelectionConditionStringLikeArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.SelectionConditionStringLikeArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.SelectionConditionStringLikeArgs =
        com.pulumi.aws.backup.inputs.SelectionConditionStringLikeArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelectionConditionStringLikeArgs].
 */
@PulumiTagMarker
public class SelectionConditionStringLikeArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The key in a key-value pair.
     */
    @JvmName("ujwasqptbdccvahm")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value in a key-value pair.
     */
    @JvmName("xjwqtedhbhdwxghp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The key in a key-value pair.
     */
    @JvmName("qqnnujhsvusbanyh")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value in a key-value pair.
     */
    @JvmName("ihloynfalxytpmnc")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SelectionConditionStringLikeArgs = SelectionConditionStringLikeArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
