@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property complianceResourceIds The ID of the only AWS resource that you want your control scope to contain. Minimum number of 1 item. Maximum number of 100 items.
 * @property complianceResourceTypes Describes whether the control scope includes one or more types of resources, such as EFS or RDS.
 * @property tags The tag key-value pair applied to those AWS resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided.
 */
public data class FrameworkControlScope(
    public val complianceResourceIds: List<String>? = null,
    public val complianceResourceTypes: List<String>? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.FrameworkControlScope): FrameworkControlScope = FrameworkControlScope(
            complianceResourceIds = javaType.complianceResourceIds().map({ args0 -> args0 }),
            complianceResourceTypes = javaType.complianceResourceTypes().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
