@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property inputParameters One or more input parameter blocks. An example of a control with two parameters is: "backup plan frequency is at least daily and the retention period is at least 1 year". The first parameter is daily. The second parameter is 1 year. Detailed below.
 * @property name Backup framework name.
 * @property scopes Scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans. Detailed below.
 */
public data class GetFrameworkControl(
    public val inputParameters: List<GetFrameworkControlInputParameter>,
    public val name: String,
    public val scopes: List<GetFrameworkControlScope>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.GetFrameworkControl): GetFrameworkControl = GetFrameworkControl(
            inputParameters = javaType.inputParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.GetFrameworkControlInputParameter.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            scopes = javaType.scopes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.GetFrameworkControlScope.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
