@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getFramework.
 * @property arn ARN of the backup framework.
 * @property controls One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
 * @property creationTime Date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC).
 * @property deploymentStatus Deployment status of a framework. The statuses are: `CREATE_IN_PROGRESS` | `UPDATE_IN_PROGRESS` | `DELETE_IN_PROGRESS` | `COMPLETED`| `FAILED`.
 * @property description Description of the framework.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of a parameter, for example, BackupPlanFrequency.
 * @property status Framework consists of one or more controls. Each control governs a resource, such as backup plans, backup selections, backup vaults, or recovery points. You can also turn AWS Config recording on or off for each resource. The statuses are: `ACTIVE`, `PARTIALLY_ACTIVE`, `INACTIVE`, `UNAVAILABLE`. For more information refer to the [AWS documentation for Framework Status](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeFramework.html#Backup-DescribeFramework-response-FrameworkStatus)
 * @property tags Tag key-value pair applied to those AWS resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided.
 */
public data class GetFrameworkResult(
    public val arn: String,
    public val controls: List<GetFrameworkControl>,
    public val creationTime: String,
    public val deploymentStatus: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.GetFrameworkResult): GetFrameworkResult = GetFrameworkResult(
            arn = javaType.arn(),
            controls = javaType.controls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.GetFrameworkControl.Companion.toKotlin(args0)
                })
            }),
            creationTime = javaType.creationTime(),
            deploymentStatus = javaType.deploymentStatus(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
