@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property completionWindow
 * @property copyActions
 * @property enableContinuousBackup
 * @property lifecycles
 * @property recoveryPointTags
 * @property ruleName
 * @property schedule
 * @property startWindow
 * @property targetVaultName
 */
public data class GetPlanRule(
    public val completionWindow: Int,
    public val copyActions: List<GetPlanRuleCopyAction>,
    public val enableContinuousBackup: Boolean,
    public val lifecycles: List<GetPlanRuleLifecycle>,
    public val recoveryPointTags: Map<String, String>? = null,
    public val ruleName: String,
    public val schedule: String,
    public val startWindow: Int,
    public val targetVaultName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.GetPlanRule): GetPlanRule =
            GetPlanRule(
                completionWindow = javaType.completionWindow(),
                copyActions = javaType.copyActions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.backup.kotlin.outputs.GetPlanRuleCopyAction.Companion.toKotlin(args0)
                    })
                }),
                enableContinuousBackup = javaType.enableContinuousBackup(),
                lifecycles = javaType.lifecycles().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.backup.kotlin.outputs.GetPlanRuleLifecycle.Companion.toKotlin(args0)
                    })
                }),
                recoveryPointTags = javaType.recoveryPointTags().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                ruleName = javaType.ruleName(),
                schedule = javaType.schedule(),
                startWindow = javaType.startWindow(),
                targetVaultName = javaType.targetVaultName(),
            )
    }
}
