@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property formats List of the format of your reports: CSV, JSON, or both.
 * @property s3BucketName Unique name of the S3 bucket that receives your reports.
 * @property s3KeyPrefix Prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name.
 */
public data class GetReportPlanReportDeliveryChannel(
    public val formats: List<String>,
    public val s3BucketName: String,
    public val s3KeyPrefix: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.GetReportPlanReportDeliveryChannel): GetReportPlanReportDeliveryChannel = GetReportPlanReportDeliveryChannel(
            formats = javaType.formats().map({ args0 -> args0 }),
            s3BucketName = javaType.s3BucketName(),
            s3KeyPrefix = javaType.s3KeyPrefix(),
        )
    }
}
