@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getReportPlan.
 * @property arn ARN of the backup report plan.
 * @property creationTime Date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC).
 * @property deploymentStatus Deployment status of a report plan. The statuses are: `CREATE_IN_PROGRESS` | `UPDATE_IN_PROGRESS` | `DELETE_IN_PROGRESS` | `COMPLETED`.
 * @property description Description of the report plan.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property reportDeliveryChannels An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
 * @property reportSettings An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
 * @property tags Metadata that you can assign to help organize the report plans you create.
 */
public data class GetReportPlanResult(
    public val arn: String,
    public val creationTime: String,
    public val deploymentStatus: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val reportDeliveryChannels: List<GetReportPlanReportDeliveryChannel>,
    public val reportSettings: List<GetReportPlanReportSetting>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.GetReportPlanResult): GetReportPlanResult = GetReportPlanResult(
            arn = javaType.arn(),
            creationTime = javaType.creationTime(),
            deploymentStatus = javaType.deploymentStatus(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            reportDeliveryChannels = javaType.reportDeliveryChannels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.GetReportPlanReportDeliveryChannel.Companion.toKotlin(args0)
                })
            }),
            reportSettings = javaType.reportSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.GetReportPlanReportSetting.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
