@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSelection.
 * @property iamRoleArn ARN of the IAM role that AWS Backup uses to authenticate when restoring and backing up the target resource. See the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#managed-policies) for additional information about using AWS managed policies or creating custom policies attached to the IAM role.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Display name of a resource selection document.
 * @property planId
 * @property resources An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan..
 * @property selectionId
 */
public data class GetSelectionResult(
    public val iamRoleArn: String,
    public val id: String,
    public val name: String,
    public val planId: String,
    public val resources: List<String>,
    public val selectionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.GetSelectionResult): GetSelectionResult = GetSelectionResult(
            iamRoleArn = javaType.iamRoleArn(),
            id = javaType.id(),
            name = javaType.name(),
            planId = javaType.planId(),
            resources = javaType.resources().map({ args0 -> args0 }),
            selectionId = javaType.selectionId(),
        )
    }
}
