@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getVault.
 * @property arn ARN of the vault.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyArn Server-side encryption key that is used to protect your backups.
 * @property name
 * @property recoveryPoints Number of recovery points that are stored in a backup vault.
 * @property tags Metadata that you can assign to help organize the resources that you create.
 */
public data class GetVaultResult(
    public val arn: String,
    public val id: String,
    public val kmsKeyArn: String,
    public val name: String,
    public val recoveryPoints: Int,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.GetVaultResult): GetVaultResult =
            GetVaultResult(
                arn = javaType.arn(),
                id = javaType.id(),
                kmsKeyArn = javaType.kmsKeyArn(),
                name = javaType.name(),
                recoveryPoints = javaType.recoveryPoints(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
