@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property backupOptions Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs. Set to `{ WindowsVSS = "enabled" }` to enable Windows VSS backup option and create a VSS Windows backup.
 * @property resourceType The type of AWS resource to be backed up. For VSS Windows backups, the only supported resource type is Amazon EC2. Valid values: `EC2`.
 */
public data class PlanAdvancedBackupSetting(
    public val backupOptions: Map<String, String>,
    public val resourceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.PlanAdvancedBackupSetting): PlanAdvancedBackupSetting = PlanAdvancedBackupSetting(
            backupOptions = javaType.backupOptions().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            resourceType = javaType.resourceType(),
        )
    }
}
