@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property completionWindow The amount of time in minutes AWS Backup attempts a backup before canceling the job and returning an error.
 * @property copyActions Configuration block(s) with copy operation settings. Detailed below.
 * @property enableContinuousBackup Enable continuous backups for supported resources.
 * @property lifecycle The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.  Fields documented below.
 * @property recoveryPointTags Metadata that you can assign to help organize the resources that you create.
 * @property ruleName An display name for a backup rule.
 * @property schedule A CRON expression specifying when AWS Backup initiates a backup job.
 * @property startWindow The amount of time in minutes before beginning a backup.
 * @property targetVaultName The name of a logical container where backups are stored.
 */
public data class PlanRule(
    public val completionWindow: Int? = null,
    public val copyActions: List<PlanRuleCopyAction>? = null,
    public val enableContinuousBackup: Boolean? = null,
    public val lifecycle: PlanRuleLifecycle? = null,
    public val recoveryPointTags: Map<String, String>? = null,
    public val ruleName: String,
    public val schedule: String? = null,
    public val startWindow: Int? = null,
    public val targetVaultName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.PlanRule): PlanRule = PlanRule(
            completionWindow = javaType.completionWindow().map({ args0 -> args0 }).orElse(null),
            copyActions = javaType.copyActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.PlanRuleCopyAction.Companion.toKotlin(args0)
                })
            }),
            enableContinuousBackup = javaType.enableContinuousBackup().map({ args0 -> args0 }).orElse(null),
            lifecycle = javaType.lifecycle().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.backup.kotlin.outputs.PlanRuleLifecycle.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recoveryPointTags = javaType.recoveryPointTags().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            ruleName = javaType.ruleName(),
            schedule = javaType.schedule().map({ args0 -> args0 }).orElse(null),
            startWindow = javaType.startWindow().map({ args0 -> args0 }).orElse(null),
            targetVaultName = javaType.targetVaultName(),
        )
    }
}
